
//------------------------------------------------------------------------------
// Copyright (c) 2012 by Silicon Laboratories. 
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Silicon Laboratories End User 
// License Agreement which accompanies this distribution, and is available at
// http://developer.silabs.com/legal/version/v10/License_Agreement_v10.htm
// Original content and implementation provided by Silicon Laboratories.
//------------------------------------------------------------------------------
// library
#include <si32McuComponent.h>
// hal
// application
#include "myApplication.h"
#include "myCPU.h"

//------------------------------------------------------------------------------
static
void halt(void)
{
  printf("Halted\n");
  // Configurable Fault Status Register
  printf(" CFSR: 0x%08X\n", SCB->CFSR);
  // Hard Fault Status Register
  printf(" HFSR: 0x%08X\n", SCB->HFSR);
  // Debug Fault Status Register
  printf(" DFSR: 0x%08X\n", SCB->DFSR);
  // Memory Management Fault Address Register
  printf("MMFAR: 0x%08X\n", SCB->MMFAR);
  // Bus Fault Address register
  printf(" BFAR: 0x%08X\n", SCB->BFAR);
  //Auxiliary Fault Status Register
  printf(" AFSR: 0x%08X\n", SCB->AFSR);
  si32Assert(0);
}

//------------------------------------------------------------------------------
void NMI_Handler(void)
{
  printf("NMI_Handler\n");
  halt();
}

//------------------------------------------------------------------------------
void HardFault_Handler(void)
{
  printf("HardFault_Handler\n");
  halt();
}

//------------------------------------------------------------------------------
void MemManage_Handler(void)
{
  printf("MemManage_Handler\n");
  halt();
}

//------------------------------------------------------------------------------
void BusFault_Handler(void)
{
  printf("BusFault_Handler\n");
  halt();
}

//------------------------------------------------------------------------------
void UsageFault_Handler(void)
{
  printf("UsageFault_Handler\n");
  halt();
}

//------------------------------------------------------------------------------
si32SystickTimerObject my_systick = si32SystickTimerObject();

//------------------------------------------------------------------------------
void SysTick_Handler(void)
{
  si32SystickTimerObject_isr(&my_systick);
}

//------------------------------------------------------------------------------
void myCPU_initialize_memory()
{
  si32SystickTimerObject_initialize(&my_systick);
  si32SetSystemTimer(&my_systick);
}

//---eof------------------------------------------------------------------------
