
//------------------------------------------------------------------------------
// Copyright (c) 2012 by Silicon Laboratories. 
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Silicon Laboratories End User 
// License Agreement which accompanies this distribution, and is available at
// http://developer.silabs.com/legal/version/v10/License_Agreement_v10.htm
// Original content and implementation provided by Silicon Laboratories.
//------------------------------------------------------------------------------
// library
#include <si32PseudOsComponent.h>
// hal
// application
#include "myUsbAudioDevice.h"

#ifndef __myDataPlane__guard__
# define __myDataPlane__guard__

// The value of myDataPlaneOutEp is manipulated in myUsbAudiodevice.c, in a poller.
// A NULL value for myDataPlaneOutEp indicates that audio-out streaming interface's
// endpoint is not enabled, and therefore no data can flow.  Non NULL indicates
// an enabled endpoint, and data can flow.  This value can change at any time
// and must be periodically checked, as it is currently the data plane thread's   
// only information about the state of the USB.  The same is true for myDataPlaneInEp,
// but for the audio-in path.
extern si32PseudoThreadObject* myDataPlaneOut;
extern si32UsbEndpointObject* myDataPlaneOutEp;
void myDataPlaneOut_initialize(void);

extern si32PseudoThreadObject* myDataPlaneIn;
extern si32UsbEndpointObject* myDataPlaneInEp;
void myDataPlaneIn_initialize(void);

#endif // __myDataPlane__guard__

//---eof------------------------------------------------------------------------
