
//------------------------------------------------------------------------------
// Copyright (c) 2012 by Silicon Laboratories. 
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Silicon Laboratories End User 
// License Agreement which accompanies this distribution, and is available at
// http://developer.silabs.com/legal/version/v10/License_Agreement_v10.htm
// Original content and implementation provided by Silicon Laboratories.
//------------------------------------------------------------------------------
// library
#include <si32McuComponent.h>
// hal
#include <si32_device.h>
// application
#include "myApplication.h"
#include "myI2C0.h"

//------------------------------------------------------------------------------
si32IicAPortalObject _my_iic0_portal = si32IicAPortalObject();
si32IicAPortalObject* my_iic0_portal = &_my_iic0_portal;

//------------------------------------------------------------------------------
void myI2C0_initialize_memory()
{
  si32LogPrologue();

  si32IicAPortalObject_initialize(my_iic0_portal,
                                  SI32_PORTAL_OBJECT_CAPABILITY_FULL_DUPLEX
                                  |SI32_PORTAL_OBJECT_CAPABILITY_TRANSMIT
                                  |SI32_PORTAL_OBJECT_CAPABILITY_RECEIVE,
                                  SI32_I2C_0);

  si32IicAPortalObject_set_configuration(my_iic0_portal,
                                         SI32_PORTAL_OBJECT_CONFIGURATION_FULL_DUPLEX
                                         |SI32_PORTAL_OBJECT_CONFIGURATION_TRANSMIT
                                         |SI32_PORTAL_OBJECT_CONFIGURATION_RECEIVE);

  si32LogEpilogue();
}

//------------------------------------------------------------------------------
void I2C0_IRQHandler(void)
{
  si32IicAPortalObject_isr(my_iic0_portal);
}

//------------------------------------------------------------------------------
void myI2C0_enter_default_mode()
{
  // TBD
}

//------------------------------------------------------------------------------
void myI2C0_enter_active_mode()
{
  SI32_I2C_A_initialize(SI32_I2C_0,
                        // control
                        SI32_I2C_A_CONTROL_RXARM_DISABLED_U32
                        |SI32_I2C_A_CONTROL_TXARM_DISABLED_U32
                        |SI32_I2C_A_CONTROL_ATXRXEN_DISABLED_U32
                        |SI32_I2C_A_CONTROL_SMINH_ACTIVE_U32
                        |SI32_I2C_A_CONTROL_HACKEN_DISABLED_U32
                        |SI32_I2C_A_CONTROL_LBACKEN_DISABLED_U32
                        //|SI32_I2C_A_CONTROL_PPUEN_DISABLED_VALUE
                        |SI32_I2C_A_CONTROL_GCEN_DISABLED_U32
                        |SI32_I2C_A_CONTROL_I2CEN_ENABLED_U32,
                        // config
                        SI32_I2C_A_CONFIG_STOIEN_ENABLED_U32
                        |SI32_I2C_A_CONFIG_ACKIEN_ENABLED_U32
                        |SI32_I2C_A_CONFIG_RXIEN_ENABLED_U32
                        |SI32_I2C_A_CONFIG_TXIEN_ENABLED_U32
                        |SI32_I2C_A_CONFIG_STAIEN_ENABLED_U32
                        |SI32_I2C_A_CONFIG_ARBLIEN_DISABLED_U32
                        |SI32_I2C_A_CONFIG_T0IEN_DISABLED_U32
                        |SI32_I2C_A_CONFIG_T1IEN_DISABLED_U32
                        |SI32_I2C_A_CONFIG_T2IEN_DISABLED_U32
                        |SI32_I2C_A_CONFIG_T3IEN_DISABLED_U32
                        |SI32_I2C_A_CONFIG_T0RUN_STOP_U32
                        |SI32_I2C_A_CONFIG_T1RUN_STOP_U32
                        |SI32_I2C_A_CONFIG_T2RUN_STOP_U32
                        |SI32_I2C_A_CONFIG_T3RUN_STOP_U32
                        |SI32_I2C_A_CONFIG_TIMEREN_DISABLED_U32,
                        // saddress
                        0,
                        // smask
                        0,
                        // timer
                        0x00FF0000,
                        // timerrl
                        0x00FF0000,
                        // sconfig
                        0,
                        // i2cdma
                        SI32_I2C_A_I2CDMA_DMAEN_DISABLED_U32);

  SI32_I2C_A_set_scaler_value(SI32_I2C_0, 0x3B);
  SI32_I2C_A_set_extended_data_setup_time(SI32_I2C_0, 4);
  NVIC_ClearPendingIRQ(I2C0_IRQn);
  NVIC_EnableIRQ(I2C0_IRQn);
}

//---eof------------------------------------------------------------------------
