
//------------------------------------------------------------------------------
// Copyright (c) 2012 by Silicon Laboratories. 
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Silicon Laboratories End User 
// License Agreement which accompanies this distribution, and is available at
// http://developer.silabs.com/legal/version/v10/License_Agreement_v10.htm
// Original content and implementation provided by Silicon Laboratories.
//------------------------------------------------------------------------------
// library
#include <si32BaseComponent.h>
// hal
#include <si32_device.h>
#include <SI32_PBSTD_A_Type.h>
#include <SI32_PBCFG_A_Type.h>
#include <SI32_CLKCTRL_A_Type.h>
// application
#include "myApplication.h"
#include "myPB.h"

#define PIN00 0x0001
#define PIN01 0x0002
#define PIN02 0x0004
#define PIN03 0x0008
#define PIN04 0x0010
#define PIN05 0x0020
#define PIN06 0x0040
#define PIN07 0x0080
#define PIN08 0x0100
#define PIN09 0x0200
#define PIN10 0x0400
#define PIN11 0x0800
#define PIN12 0x1000
#define PIN13 0x2000
#define PIN14 0x4000
#define PIN15 0x8000

//------------------------------------------------------------------------------
void PMATCH_IRQHandler() 
{
  si32Assert(NO);
}

//------------------------------------------------------------------------------
void myPB_enter_off_mode()
{
  // disable crossbar 1.
  SI32_PBCFG_A_disable_crossbar_1(SI32_PBCFG_0);
  
  // Enable APB clock only to the Port Bank module.
  SI32_CLKCTRL_A_enable_apb_to_modules_0(SI32_CLKCTRL_0,
                                         SI32_CLKCTRL_A_APBCLKG0_PB0
                                         |SI32_CLKCTRL_A_APBCLKG0_USB0        
                                         //|SI32_CLKCTRL_A_APBCLKG0_PLL0
                                         );
  SI32_CLKCTRL_A_disable_apb_to_modules_0(SI32_CLKCTRL_0, 
                                          ~(
                                            SI32_CLKCTRL_A_APBCLKG0_PB0
                                            |SI32_CLKCTRL_A_APBCLKG0_USB0
                                            //|SI32_CLKCTRL_A_APBCLKG0_PLL0        
                                          ));
  SI32_CLKCTRL_A_disable_apb_to_modules_1(SI32_CLKCTRL_0,
                                          SI32_CLKCTRL_A_APBCLKG1_MISC0
                                          |SI32_CLKCTRL_A_APBCLKG1_MISC1
                                          );
  
  // All ports hi-z except the SWO pin (PB1.3) push-pull to enable SWV printf.
  SI32_PBSTD_A_set_pins_digital_input(SI32_PBSTD_0, 0x0000FFFF);
  SI32_PBSTD_A_set_pins_digital_input(SI32_PBSTD_1, 0x0000FFF7);
  SI32_PBSTD_A_set_pins_push_pull_output(SI32_PBSTD_1, 0x00000008);
  SI32_PBSTD_A_set_pins_digital_input(SI32_PBSTD_2, 0x0000FFFF);
  SI32_PBSTD_A_set_pins_digital_input(SI32_PBSTD_3, 0x00007FFF);
}
//------------------------------------------------------------------------------
void myPB_enter_default_mode()
{
  myPB_enter_off_mode();
}
//------------------------------------------------------------------------------
void myPB_enter_active_mode()
{
  SI32_CLKCTRL_A_enable_apb_to_modules_0(SI32_CLKCTRL_0,
                                         SI32_CLKCTRL_A_APBCLKG0_PB0
                                         //|SI32_CLKCTRL_A_APBCLKG0_PLL0         
                                         //|SI32_CLKCTRL_A_APBCLKG0_USART0       
                                         //|SI32_CLKCTRL_A_APBCLKG0_USART1       
                                         |SI32_CLKCTRL_A_APBCLKG0_UART0        
                                         //|SI32_CLKCTRL_A_APBCLKG0_UART1        
                                         |SI32_CLKCTRL_A_APBCLKG0_SPI0         
                                         //|SI32_CLKCTRL_A_APBCLKG0_SPI1         
                                         //|SI32_CLKCTRL_A_APBCLKG0_SPI2         
                                         |SI32_CLKCTRL_A_APBCLKG0_I2C0         
                                         //|SI32_CLKCTRL_A_APBCLKG0_I2C1         
                                         //|SI32_CLKCTRL_A_APBCLKG0_EPCA0        
                                         //|SI32_CLKCTRL_A_APBCLKG0_PCA0         
                                         //|SI32_CLKCTRL_A_APBCLKG0_PCA1         
                                         //|SI32_CLKCTRL_A_APBCLKG0_SSG0         
                                         |SI32_CLKCTRL_A_APBCLKG0_TIMER0       
                                         //|SI32_CLKCTRL_A_APBCLKG0_TIMER1       
                                         //|SI32_CLKCTRL_A_APBCLKG0_SARADC0      
                                         //|SI32_CLKCTRL_A_APBCLKG0_SARADC1      
                                         //|SI32_CLKCTRL_A_APBCLKG0_CMP0         
                                         //|SI32_CLKCTRL_A_APBCLKG0_CMP1         
                                         //|SI32_CLKCTRL_A_APBCLKG0_CAPSENSE0    
                                         //|SI32_CLKCTRL_A_APBCLKG0_AES0        
                                         //|SI32_CLKCTRL_A_APBCLKG0_CRC0        
                                         //|SI32_CLKCTRL_A_APBCLKG0_IDAC0       
                                         //|SI32_CLKCTRL_A_APBCLKG0_IDAC1       
                                         //|SI32_CLKCTRL_A_APBCLKG0_LPTIMER0    
                                         |SI32_CLKCTRL_A_APBCLKG0_I2S0        
                                         |SI32_CLKCTRL_A_APBCLKG0_USB0        
                                         |SI32_CLKCTRL_A_APBCLKG0_EXTVREG0    
                                         //|SI32_CLKCTRL_A_APBCLKG0_FLASHCTRL0
                                         );

  SI32_CLKCTRL_A_disable_apb_to_modules_1(SI32_CLKCTRL_0,
                                          SI32_CLKCTRL_A_APBCLKG1_MISC0
                                          |SI32_CLKCTRL_A_APBCLKG1_MISC1
                                          );
//  SI32_CLKCTRL_A_enable_apb_to_modules_1(SI32_CLKCTRL_0,
//                                          SI32_CLKCTRL_A_APBCLKG1_MISC1
//                                          );

  uint32 jtag = SI32_PBCFG_A_CONTROL1_JTAGEN_DISABLED_U32;
  if (CoreDebug->DHCSR & CoreDebug_DHCSR_C_DEBUGEN_Msk)
  {
     jtag = SI32_PBCFG_A_CONTROL1_JTAGEN_ENABLED_U32;
  }
                                          
  SI32_PBCFG_A_initialize(SI32_PBCFG_0,
                          // control0
                          0x00000000,
                          // control1
                          jtag,
                          // xbar0l
                          SI32_PBCFG_A_XBAR0L_SPI0EN_ENABLED_U32
                          |SI32_PBCFG_A_XBAR0L_SPI0NSSEN_ENABLED_U32
                          |SI32_PBCFG_A_XBAR0L_I2S0TXEN_ENABLED_U32
                          |SI32_PBCFG_A_XBAR0L_I2C0EN_ENABLED_U32
                          |SI32_PBCFG_A_XBAR0L_TMR0EXEN_ENABLED_U32,
                          // xbar0h
                          SI32_PBCFG_A_XBAR0H_XBAR0EN_ENABLED_U32
                          |SI32_PBCFG_A_XBAR0H_UART0EN_ENABLED_U32
                          |SI32_PBCFG_A_XBAR0H_UART0FCEN_ENABLED_U32
                          |SI32_PBCFG_A_XBAR0H_UART0FCEN_ENABLED_U32,
                          // xbar1
                          SI32_PBCFG_A_XBAR1_XBAR1EN_ENABLED_U32
                          |SI32_PBCFG_A_XBAR1_I2S0RXEN_ENABLED_U32,
                          // pbkey
                          SI32_PBCFG_A_CONTROL1_LOCK_UNLOCKED_U32);    

  // P0.00 
  // P0.01
  // P0.02
  // P0.03
  // P0.04
  // P0.05 SPI0_SCK  (SD CARD CLK/SCLK)
  // P0.06 SPI0_MISO (SD CARD DAT0/MISO)
  // P0.07 SPI0_MOSI (SD CARD CMD/MOSI)
  // P0.08 SPI0_NSS  (SD CARD DAT3/CS)    
  // P0.09
  // P0.10 
  // P0.11 
  // P0.12 
  // P0.13 e
  // P0.14 I2S0_OUT_WS
  // P0.15 I2S0_OUT_SCK
  SI32_PBSTD_A_write_pbskipen(SI32_PBSTD_0,
                              PIN00
                              |PIN01
                              |PIN02
                              |PIN03
                              |PIN04
                              |PIN09
                              |PIN10
                              |PIN11
                              |PIN12
                              |PIN13);
  
  SI32_PBSTD_A_set_pins_push_pull_output(SI32_PBSTD_0,
                                         PIN05
                                         |PIN07
                                         |PIN08
                                         |PIN14
                                         |PIN15);
  
  SI32_PBSTD_A_set_pins_digital_input(SI32_PBSTD_0,
                                      PIN06);
  
  // P1.00 I2S0_OUT_SD
  // P1.01 I2C0_SDA
  // P1.02 I2C0_SCL
  // P1.03
  // P1.04
  // P1.05 ADC_IN0 (AUDIO CARD POT)
  // P1.06 ADC_IN1 (AUDIO CARD ALT MIC IN)
  // P1.07
  // P1.08
  // P1.09
  // P1.10
  // P1.11 TIMER_EX_A
  // P1.12 UART0_TX
  // P1.13 UART0_RX
  // P1.14 UART0_RTS
  // P1.15 UART0_CTS
  SI32_PBSTD_A_write_pbskipen(SI32_PBSTD_1,
                              PIN03
                              |PIN04
                              |PIN05
                              |PIN06
                              |PIN07
                              |PIN08
                              |PIN09
                              |PIN10);
  
  SI32_PBSTD_A_set_pins_push_pull_output(SI32_PBSTD_1,
                                         PIN00
                                         |PIN11
                                         |PIN12
                                         |PIN14);
  
  SI32_PBSTD_A_set_pins_digital_input(SI32_PBSTD_1,
                                      PIN01
                                      |PIN02
                                      |PIN13
                                      |PIN15);
  
  SI32_PBSTD_A_set_pins_analog(SI32_PBSTD_1,
                               PIN05
                               |PIN06);     

  SI32_PBSTD_A_set_pins_high_drive_strength(SI32_PBSTD_1,
                                            PIN11);
  // P2.00
  // P2.01
  // P2.02
  // P2.03
  // P2.04
  // P2.05 GPIO00 (AUDIO CARD SW2)
  // P2.06 GPIO01 (AUDIO CARD SW3)
  // P2.07 GPIO02 (AUDIO CARD YELLOW LED)
  // P2.08 GPIO03 (SD POWER)
  // P2.09 GPIO04 (SD CARD DETECT)
  // P2.10 GPIO05 (MCU CARD RED LED)      -- scope probe
  // P2.11 GPIO06 (MCU CARD YELLOW LED)   -- scope probe
  // P2.12                                -- scope probe
  // P2.13                                -- scope probe
  // P2.14
  // P2.15
  
  SI32_PBSTD_A_write_pbskipen(SI32_PBSTD_2,
                              PIN00
                              |PIN01
                              |PIN02
                              |PIN03
                              |PIN04
                              |PIN05
                              |PIN06
                              |PIN07
                              |PIN08
                              |PIN09
                              |PIN10
                              |PIN11
                              |PIN12
                              |PIN13
                              |PIN14
                              |PIN15);
  
  SI32_PBSTD_A_set_pins_push_pull_output(SI32_PBSTD_2,
                                         PIN07
                                         |PIN08
                                         |PIN10
                                         |PIN11
                                         |PIN12
                                         |PIN13);
  
  SI32_PBSTD_A_set_pins_digital_input(SI32_PBSTD_2,
                                      PIN05
                                      |PIN06
                                      //|PIN08
                                      |PIN09
                                      );

  // power on the sd card slot
  //SI32_PBSTD_A_write_pins_high(SI32_PBSTD_2, 0x0100);
  //SI32_PBSTD_A_write_pins_low(SI32_PBSTD_2, 0x0100);
 
  // P3.00 
  // P3.01 
  // P3.02
  // P3.03 I2S0_IN_WS
  // P3.04 I2S0_IN_SCK
  // P3.05 I2S0_IN_SD
  // P3.06
  // P3.07
  // P3.08 EXTVREG_RSP
  // P3.09 EXTVREG_RSN
  // P3.10 EXTVREG_OUT
  // P3.11 EXTVREG_BD
  // P3.12
  // P3.13
  // P3.14
  // P3.15
  
  SI32_PBSTD_A_write_pbskipen(SI32_PBSTD_3,
                              PIN00
                              |PIN01
                              |PIN02
                              |PIN06
                              |PIN07
                              |PIN08
                              |PIN09
                              |PIN10
                              |PIN11
                              |PIN12
                              |PIN13
                              |PIN14
                              |PIN15);
  
  SI32_PBSTD_A_set_pins_push_pull_output(SI32_PBSTD_3,
                                        PIN03
                                        |PIN04);
  
  SI32_PBSTD_A_set_pins_digital_input(SI32_PBSTD_3,
                                      PIN05);
  
   SI32_PBSTD_A_set_pins_analog(SI32_PBSTD_3, PIN08
                                              | PIN09 
                                              | PIN10 
                                              | PIN11);
  // P4.00 
  // P4.01 
  // P4.02
  // P4.03 
  // P4.04 
  // P4.05 
}

//---eof------------------------------------------------------------------------
