//------------------------------------------------------------------------------
// Copyright (c) 2012 by Silicon Laboratories. 
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Silicon Laboratories End User 
// License Agreement which accompanies this distribution, and is available at
// http://developer.silabs.com/legal/version/v10/License_Agreement_v10.htm
// Original content and implementation provided by Silicon Laboratories.
//------------------------------------------------------------------------------

#ifndef  __myUsbAudioDevice__
#define  __myUsbAudioDevice__

// library
#include <si32UsbComponent.h>
#include <si32UsbAudioComponent.h>

//------------------------------------------------------------------------------
#define USB_VENDOR_ID_SILICON_LABS        (0x10C4)

#define USB_PRODUCT_ID__SI32_GENERIC      (0xff00)
#define USB_PRODUCT_ID__SI32_MASS_STORAGE (0xff10)
#define USB_PRODUCT_ID__SI32_USBHID       (0xff20)
#define USB_PRODUCT_ID__SI32_USBAUDIO     (0xff30)
#define USB_PRODUCT_ID__SI32_USBCDC       (0xff40)

extern si32UsbDeviceDescriptorType        myUsbAudioDeviceDescriptor;
extern si32UsbConfigurationDescriptorType myUsbAudioConfigurationDescriptor;
extern si32UsbInterfaceDescriptorType     myUsbAudioInterfaceDescriptor;
extern si32UsbEndpointDescriptorType      myUsbAudioEndpointDescriptor;

extern si32UsbDeviceObject*               myUsbAudioDevice;
extern si32UsbConfigurationObject*        myUsbAudioConfiguration;
extern si32UsbInterfaceObject*            myUsbAudioInterface;
extern si32UsbEndpointObject*             myUsbAudioEndpoint[2];

// need to be able to talk to some ep...
//extern si32UsbAudioStreamingEndpointObject myUsbAudioStreamingEndpointOutObject;
extern si32UsbAudioStreamingInterfaceObject myUsbAudioStreamingInterfaceOutObject_1;

// Middleware Device Object 'bundle'
extern si32UsbDeviceObject* myUsbDevice;

// Single entrypoint
extern void myUsb0_main(si32UsbDeviceObject * pDevice);
extern void myUsbAudioDevice_main(void);

#endif

//-eof--------------------------------------------------------------------------
