//------------------------------------------------------------------------------
// Copyright (c) 2012 by Silicon Laboratories. 
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Silicon Laboratories End User 
// License Agreement which accompanies this distribution, and is available at
// http://developer.silabs.com/legal/version/v10/License_Agreement_v10.htm
// Original content and implementation provided by Silicon Laboratories.
//------------------------------------------------------------------------------

//==============================================================================
// WARNING:
//
// This file is auto-generated by AppBuilder and should not be modified.
// Any hand modifications will be lost if the project is regenerated.
//==============================================================================
// library
// hal
#include <si32_device.h>
#include <SI32_PBHD_A_Type.h>
#include <SI32_PBSTD_A_Type.h>
#include <SI32_PBCFG_A_Type.h>
#include <SI32_CLKCTRL_A_Type.h>
// application
#include "gPB.h"

//==============================================================================
// CONFIGURATION FUNCTIONS
//==============================================================================
void gPB_enter_off_config()
{
   // All ports set as digital inputs
   SI32_PBSTD_A_set_pins_digital_input(SI32_PBSTD_0, 0x0000FFFF);
   SI32_PBSTD_A_set_pins_digital_input(SI32_PBSTD_1, 0x0000FFFF);
   SI32_PBSTD_A_set_pins_digital_input(SI32_PBSTD_2, 0x0000FFFF);
   SI32_PBSTD_A_set_pins_digital_input(SI32_PBSTD_3, 0x00007FFF);

   SI32_PBCFG_A_disable_crossbar_1(SI32_PBCFG_0);

   SI32_CLKCTRL_A_disable_apb_to_modules_0(SI32_CLKCTRL_0,
      SI32_CLKCTRL_A_APBCLKG0_PB0);
}

//------------------------------------------------------------------------------
// Sets up ports for all peripherals
// NOTE 'default' Refers to the default device setup for the application.
void gPB_enter_default_config()
{
   // Enable the APB clock to the PB registers
   // Enable SW printf
   SI32_CLKCTRL_A_enable_apb_to_modules_0(SI32_CLKCTRL_0,
      SI32_CLKCTRL_A_APBCLKG0_PB0);
   SI32_PBSTD_A_set_pins_push_pull_output(SI32_PBSTD_1, 0x00000008);

   // Enable Crossbar 1, where the example drives LEDs, samples buttons, and
   // outputs the RTC clock.
   SI32_PBCFG_A_enable_crossbar_1(SI32_PBCFG_0);

   // GPIO Port Bank setup
   // Enable the LED drivers (P2.10, P2.11)
   SI32_PBSTD_A_set_pins_push_pull_output(SI32_PBSTD_2, 0x00000C00);

   // Enable switch sensing (P2.10, P2.11)
   SI32_PBSTD_A_set_pins_digital_input(SI32_PBSTD_2, 0x00000300);

   // RTC Port Bank setup
   // Set the RTC oscillator pins to analog mode (PB0.9, PB0.10)
   SI32_PBSTD_A_set_pins_analog(SI32_PBSTD_0, 0x00000600);

   // Ouptut the RTC0 clock (PB2.7)
   SI32_PBSTD_A_set_pins_push_pull_output(SI32_PBSTD_2, 0x00000080);
   SI32_PBSTD_A_write_pbskipen(SI32_PBSTD_2, 0x0000007F);
   SI32_PBCFG_A_enable_xbar1_peripherals(SI32_PBCFG_0,
      SI32_PBCFG_A_XBAR1_RTC0EN);
}

//---eof------------------------------------------------------------------------
