//------------------------------------------------------------------------------
// Copyright (c) 2012 by Silicon Laboratories. 
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Silicon Laboratories End User 
// License Agreement which accompanies this distribution, and is available at
// http://developer.silabs.com/legal/version/v10/License_Agreement_v10.htm
// Original content and implementation provided by Silicon Laboratories.
//------------------------------------------------------------------------------

//==============================================================================
// WARNING:
//
// This file is auto-generated by AppBuilder and should not be modified.
// Any hand modifications will be lost if the project is regenerated.
//==============================================================================
// library
// hal
#include <si32_device.h>
#include <SI32_CLKCTRL_A_Type.h>
#include <SI32_RTC_A_Type.h>
// application
#include "gRtc0.h"

//==============================================================================
// 2nd Level Interrupt Handlers
//==============================================================================
extern void my_rtc_fail_handler(void);
extern void my_rtc_alarm0_handler(void);

//==============================================================================
//1st LEVEL  INTERRUPT HANDLERS
//==============================================================================
// Prints the value sensed at the end of each convert, and a newline at the end
// of each scan
void RTC0FAIL_IRQHandler(void)
{
   my_rtc_fail_handler();
}

//------------------------------------------------------------------------------
void RTC0ALRM_IRQHandler(void)
{
   // HANDLE ALARM 0
   if (SI32_RTC_A_is_alarm0_interrupt_pending(SI32_RTC_0))
   {
      my_rtc_alarm0_handler();
   }// if ALARM 0

   // HANDLE ALARM 1
   if (SI32_RTC_A_is_alarm1_interrupt_pending(SI32_RTC_0))
   {
    /*NO SECOND LEVEL HANDLER SPECIFIED*/
   }// if ALARM 1

   // HANDLE ALARM 2
   if (SI32_RTC_A_is_alarm2_interrupt_pending(SI32_RTC_0))
   {
    /*NO SECOND LEVEL HANDLER SPECIFIED*/
   }// if ALARM 2
}

//==============================================================================
//CONFIGURATION FUNCTIONS
//==============================================================================
void gRtc0_enter_off_config(void)
{
   // Disable interrupts
   SI32_RTC_A_disable_alarm0_interrupt(SI32_RTC_0);
   NVIC_ClearPendingIRQ(RTC0FAIL_IRQn);
   NVIC_ClearPendingIRQ(RTC0ALRM_IRQn);
   NVIC_DisableIRQ(RTC0FAIL_IRQn);
   NVIC_DisableIRQ(RTC0ALRM_IRQn);

   // Stop the RTC
   SI32_RTC_A_stop_timer(SI32_RTC_0);
   SI32_RTC_A_enable_module(SI32_RTC_0);

   // Disable the RTC clock (+ IVC0 EXTVREG0 EXTOSC0 LDO VREG0 VMON0)
   SI32_CLKCTRL_A_disable_apb_to_modules_1(SI32_CLKCTRL_0,
      SI32_CLKCTRL_A_APBCLKG1_MISC0);
}

//------------------------------------------------------------------------------
void gRtc0_enter_default_config(void)
{
   // Enable the RTC clock (+ IVC0 EXTVREG0 EXTOSC0 LDO VREG0 VMON0)
   SI32_CLKCTRL_A_enable_apb_to_modules_1(SI32_CLKCTRL_0,
      SI32_CLKCTRL_A_APBCLKG1_MISC0);

   // Set up the RTC
   SI32_RTC_A_enable_module(SI32_RTC_0);
   SI32_RTC_A_enable_crystal_oscillator(SI32_RTC_0);
   SI32_RTC_A_set_clock_source_rtc(SI32_RTC_0);
   SI32_RTC_A_disable_bias_doubler(SI32_RTC_0);
   SI32_RTC_A_enable_autostep(SI32_RTC_0);
   SI32_RTC_A_enable_auto_gain_control(SI32_RTC_0);

   // Start the RTC and wait for the loadcap setting to settle
   SI32_RTC_A_start_timer(SI32_RTC_0);
   while(!SI32_RTC_A_is_load_capacitance_ready(SI32_RTC_0));

   // Load the current timer value into SETCAP
   SI32_RTC_A_start_timer_capture(SI32_RTC_0);
   while(SI32_RTC_A_is_timer_capture_in_progress(SI32_RTC_0));

   // Set the alarm for now + 327 counts, which is 10 ms
   SI32_RTC_A_write_alarm0(SI32_RTC_0, SI32_RTC_A_read_setcap(SI32_RTC_0) + 327);
   SI32_RTC_A_clear_alarm0_interrupt(SI32_RTC_0);

   // Enable interrupts
   NVIC_ClearPendingIRQ(RTC0FAIL_IRQn);
   NVIC_ClearPendingIRQ(RTC0ALRM_IRQn);
   NVIC_EnableIRQ(RTC0FAIL_IRQn);
   NVIC_EnableIRQ(RTC0ALRM_IRQn);
   SI32_RTC_A_enable_alarm0_interrupt(SI32_RTC_0);

   // Enable the RTC pin output
   SI32_RTC_A_enable_external_pin_clock_drive(SI32_RTC_0);
}

//-eof--------------------------------------------------------------------------
