/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.customizer.actions;

import com.silabs.customizer.devices.Device;
import com.silabs.customizer.devices.DeviceNone;
import com.silabs.customizer.log.MessageLog;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;

public class RestoreSiliconLabsDefaultsAction
extends Action
implements ISelectionChangedListener {
    private final List<Viewer> viewers = new LinkedList<Viewer>();
    private Device device;

    public RestoreSiliconLabsDefaultsAction() {
        super("Restore Silicon Labs Defaults");
        this.setId(RestoreSiliconLabsDefaultsAction.class.getName());
        this.setEnabled(false);
    }

    public void addViewer(Viewer viewer) {
        if (viewer != null) {
            this.viewers.add(viewer);
        }
    }

    public void removeViewer(Viewer viewer) {
        if (viewer != null) {
            this.viewers.remove(viewer);
        }
    }

    public void run() {
        MessageLog.info("Restore Silicon Labs device defaults: " + this.device);
        this.device.resetSiliconLabsDefaultValues();
        for (Viewer viewer : this.viewers) {
            viewer.refresh();
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection sSelection = (IStructuredSelection)selection;
            Object first = sSelection.getFirstElement();
            this.device = first instanceof Device && !(first instanceof DeviceNone) ? (Device)first : null;
            this.setEnabled(this.device != null);
        }
    }
}

