/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.customizer.devices;

import com.silabs.customizer.FileUtils;
import com.silabs.customizer.devices.Device;
import com.silabs.customizer.devices.DeviceNone;
import com.silabs.customizer.devices.IDeviceListener;
import com.silabs.customizer.devices.LoadVisitor;
import com.silabs.customizer.devices.SaveVisitor;
import com.silabs.customizer.devices.cp210x.Device210x;
import com.silabs.customizer.devices.cp211x.Device211x;
import com.silabs.customizer.devices.cp213x.Device213x;
import com.silabs.customizer.log.MessageLog;
import com.silabs.customizer.preferences.PreferenceConstants;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public final class DeviceDetector {
    private static final int DELAY_MS = 1000;
    private static final DeviceDetector INSTANCE = new DeviceDetector();
    private final Set<IDeviceListener> listeners = new HashSet<IDeviceListener>();
    private List<Device> devices = new LinkedList<Device>();
    private Device selectedDevice = null;
    boolean waitForDeviceReset = false;
    private Thread thread;
    private volatile boolean pause;

    public static DeviceDetector getDefault() {
        return INSTANCE;
    }

    private DeviceDetector() {
    }

    public synchronized void addListener(IDeviceListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public synchronized Device[] getDevices() {
        return this.devices.toArray(new Device[this.devices.size()]);
    }

    public synchronized boolean isStopped() {
        return this.pause;
    }

    public synchronized void removeListener(IDeviceListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    public synchronized void saveSettings(Device device) {
        if (this.isRetain() && device != null && !(device instanceof DeviceNone)) {
            try {
                File file = this.getFile(device);
                if (!file.exists() || file.canWrite()) {
                    MessageLog.debug("Auto-save to:", file);
                    SaveVisitor.save(file, device);
                }
            }
            catch (Exception exc) {
                MessageLog.error("Could not save settings for " + device.getType(), exc);
            }
        }
    }

    public synchronized void start() {
        MessageLog.debug("DeviceDetector: DETECT");
        this.pause = false;
        this.detect();
        this.pause = true;
    }

    public synchronized void stop() {
    }

    private synchronized void detect() {
        if (this.pause) {
            return;
        }
        LinkedList<Device> result = new LinkedList<Device>();
        String osName = System.getProperty("os.name");
        if (!osName.equals("Mac OS X") && osName.indexOf("nix") < 0 && osName.indexOf("nux") < 0 && osName.indexOf("aix") <= 0) {
            try {
                result.addAll(Device213x.getDevices());
            }
            catch (Exception exception) {}
        }
        if (!osName.equals("Mac OS X")) {
            result.addAll(Device210x.getDevices());
        }
        result.addAll(Device211x.getDevices());
        if (result.isEmpty()) {
            result.add(new DeviceNone());
        }
        Collections.sort(result);
        if (this.waitForDeviceReset) {
            if (result.contains(this.selectedDevice)) {
                this.waitForDeviceReset = false;
            } else {
                return;
            }
        }
        if (!result.equals(this.devices)) {
            this.updateLog(result);
            this.devices = result;
            this.fireDevicesChanged();
        }
    }

    private synchronized void fireDevicesChanged() {
        for (IDeviceListener listener : this.listeners) {
            try {
                listener.devicesChanged();
            }
            catch (Exception e) {
                MessageLog.error("Exception in IDeviceListener", e);
            }
        }
    }

    private synchronized File getFile(Device device) throws Exception {
        File dir = FileUtils.getConfigLocation();
        return new File(dir, String.valueOf(device.getType()) + ".prefs");
    }

    private synchronized boolean isRetain() {
        return PreferenceConstants.getStore().getBoolean("PREF_RETAIN_DEVICE_CONFIG");
    }

    private synchronized void loadSettings(Device device) {
        if (this.isRetain()) {
            try {
                File file = this.getFile(device);
                if (file.canRead()) {
                    MessageLog.debug("Auto-load from:", file);
                    LoadVisitor.load(file, device);
                }
            }
            catch (Exception exc) {
                MessageLog.error("Could not load settings for " + device.getType(), exc);
            }
        }
    }

    private synchronized void updateLog(List<Device> result) {
        MessageLog log = new MessageLog();
        for (Device device : this.devices) {
            if (device instanceof DeviceNone || result.contains(device)) continue;
            log.logInfo("Device disconnected: " + device.getName());
            this.saveSettings(device);
        }
        for (Device device : result) {
            if (device instanceof DeviceNone || this.devices.contains(device)) continue;
            log.logInfo("Device connected: " + device.getName());
            this.loadSettings(device);
        }
        log.dispose();
    }

    public synchronized void setSelectedDevice(Device device) {
        this.selectedDevice = device;
    }

    public synchronized void startWaitForReset() {
        this.waitForDeviceReset = true;
    }

    public synchronized boolean isWaitingForReset() {
        return this.waitForDeviceReset;
    }

    public synchronized void cancelWaitForReset() {
        this.waitForDeviceReset = false;
    }
}

