/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.customizer.devices;

import com.silabs.customizer.devices.GenericValueDialogButton;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class GenericValueDialog
extends StatusDialog {
    private GenericValueDialogButton[] buttons;
    private Button[] bits;
    private Label lblDescr;
    private String description;
    private Label lblResult;
    private String value;
    private int valueSize;

    public GenericValueDialog(Shell parent, String title, String description, String value, int valueSize, GenericValueDialogButton[] buttons) {
        super(parent);
        this.buttons = buttons;
        this.bits = new Button[this.buttons.length];
        this.setShellStyle(this.getShellStyle() | 0x10000000);
        this.setTitle(title);
        this.setDescription(description);
        this.setValue(value, valueSize);
    }

    public String getValue() {
        return this.value;
    }

    public final void setDescription(String description) {
        this.description = description;
        if (this.lblDescr != null) {
            this.lblDescr.setText(description);
        }
    }

    public final void setValue(String hexString, int hexStringSize) {
        this.valueSize = hexStringSize;
        if (hexString.length() > hexStringSize) {
            throw new NumberFormatException("hexWord: " + String.valueOf(hexString));
        }
        if (this.bits[0] == null) {
            this.value = hexStringSize == 2 ? String.format("%02X", Integer.parseInt(hexString, 16)) : (hexStringSize == 4 ? String.format("%04X", Integer.parseInt(hexString, 16)) : String.format("%08X", Integer.parseInt(hexString, 16)));
        } else {
            Integer hexValue = Integer.parseInt(hexString, 16);
            int i = 0;
            while (i < this.bits.length) {
                if (this.buttons[i].isEnabled()) {
                    this.bits[i].setSelection((hexValue >> i & 1) == 1);
                } else {
                    this.bits[i].setSelection(this.buttons[i].getDefaultSelection());
                }
                ++i;
            }
            this.value = this.computeValue();
        }
    }

    protected Control createDialogArea(Composite parent) {
        FontData[] fontDatas;
        Composite result = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)result.getLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        GridDataFactory gdfFill2 = GridDataFactory.fillDefaults().grab(true, false).span(4, 1);
        this.lblDescr = new Label(result, 64);
        this.lblDescr.setText(String.valueOf(this.description));
        gdfFill2.copy().minSize(250, -1).applyTo((Control)this.lblDescr);
        this.createSpacer(result);
        int middle = this.buttons.length / 2;
        if (this.buttons.length % 2 == 1) {
            ++middle;
        }
        int i = 0;
        while (i < middle) {
            this.bits[i] = this.createButton(result, this.buttons[i].getName());
            this.bits[i].setEnabled(this.buttons[i].isEnabled());
            if (i + middle < this.buttons.length) {
                this.bits[i + middle] = this.createButton(result, this.buttons[i + middle].getName());
                this.bits[i + middle].setEnabled(this.buttons[i + middle].isEnabled());
            }
            ++i;
        }
        result.setTabList((Control[])this.bits);
        this.createSpacer(result);
        this.lblResult = new Label(result, 0);
        this.setValue(this.value, this.valueSize);
        this.lblResult.setText("Result (hex): " + this.value);
        gdfFill2.applyTo((Control)this.lblResult);
        FontData[] fontDataArray = fontDatas = this.lblResult.getFont().getFontData();
        int n = fontDatas.length;
        int n2 = 0;
        while (n2 < n) {
            FontData fd = fontDataArray[n2];
            fd.setStyle(1);
            ++n2;
        }
        final Font fontBold = new Font((Device)this.lblResult.getDisplay(), fontDatas);
        this.lblResult.setFont(fontBold);
        this.lblResult.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                fontBold.dispose();
            }
        });
        this.addListeners();
        return result;
    }

    private void addListeners() {
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GenericValueDialog.this.value = GenericValueDialog.this.computeValue();
                GenericValueDialog.this.lblResult.setText("Result (hex): " + GenericValueDialog.this.value);
            }
        };
        Button[] buttonArray = this.bits;
        int n = this.bits.length;
        int n2 = 0;
        while (n2 < n) {
            Button button = buttonArray[n2];
            button.addSelectionListener((SelectionListener)selectionListener);
            ++n2;
        }
    }

    private String computeValue() {
        long value = 0L;
        int i = 0;
        while (i < this.bits.length) {
            value |= (long)((this.bits[i].getSelection() ? 1 : 0) << i);
            ++i;
        }
        String result = this.valueSize == 2 ? String.format("%02X", value) : (this.valueSize == 4 ? String.format("%04X", value) : String.format("%08X", value));
        return result;
    }

    private Button createButton(Composite parent, String caption) {
        Button result = new Button(parent, 32);
        result.setText(caption);
        return result;
    }

    private void createSpacer(Composite result) {
        Label lblSpacer = new Label(result, 0);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)lblSpacer);
    }
}

