/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.customizer.devices;

import com.silabs.customizer.devices.CellEditorFactory;
import com.silabs.customizer.devices.Device;
import com.silabs.customizer.devices.FlushBuffersCellEditor;
import com.silabs.customizer.devices.Property;
import java.util.Locale;

public class PropertyFlushBuffers
extends Property {
    int numFlushInterfaces;

    public PropertyFlushBuffers(Device device, int numFlushInterfaces) {
        super(device, null, "Flush Buffers (hex)", null);
        this.numFlushInterfaces = numFlushInterfaces;
        this.initProperty();
    }

    @Override
    public CellEditorFactory getCellEditorFactory() {
        return FlushBuffersCellEditor.getFactory(this.numFlushInterfaces);
    }

    @Override
    public void setDefaultValue(String value) {
        super.setDefaultValue(value.toUpperCase(Locale.ENGLISH));
    }

    @Override
    public void setValue(String value) {
        try {
            Integer intValue = Integer.parseInt(value, 16);
            if (intValue <= 65535) {
                super.setValue(String.format("%04X", intValue));
            }
        }
        catch (NumberFormatException numberFormatException) {}
    }

    @Override
    protected String readValueFromDevice() throws Exception {
        return this.getDevice().getFlushBuffers(this.getDevice());
    }

    @Override
    protected void writeToDevice() throws Exception {
        this.getDevice().setFlushBuffers(this.getDevice(), this.getValue());
    }
}

