/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.customizer.devices;

import com.silabs.customizer.devices.Device;
import com.silabs.customizer.devices.Property;
import java.util.Locale;

public class PropertyReleaseVer
extends Property {
    public PropertyReleaseVer(Device device) {
        super(device, null, "Release Version (Maj., Min.)", null);
        this.initProperty();
    }

    @Override
    public void setDefaultValue(String value) {
        super.setDefaultValue(value.toUpperCase(Locale.ENGLISH));
    }

    @Override
    public void setValue(String value) {
        try {
            Integer intValue = Integer.parseInt(value, 16);
            if (intValue <= 65535) {
                super.setValue(String.format("%04X", intValue));
            }
        }
        catch (NumberFormatException numberFormatException) {}
    }

    @Override
    protected String readValueFromDevice() throws Exception {
        return this.getDevice().getReleaseVersion(this.getDevice());
    }

    @Override
    protected void writeToDevice() throws Exception {
        this.getDevice().setReleaseVersion(this.getDevice(), this.getValue());
    }
}

