/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.customizer.devices.cp210x;

import java.util.Arrays;

public final class CP2103_4PinConfig {
    public static final int expectedPinCount = 13;
    final byte[] pinConfigs;
    final int useUartSuspendValues;
    final int useGPIOSuspendValues;
    final int suspendValue;
    final int resetValue;
    int latchControl;
    final int enableWeakPullUp;
    final int rs485Invert;

    CP2103_4PinConfig(byte[] pinConfigs, int useUartSuspendValues, int useGPIOSuspendValues, int suspendValue, int resetValue, int latchControl, int enableWeakPullUp, int rs485Invert) {
        if (pinConfigs.length != 13) {
            throw new IllegalArgumentException("pinConfig.length != expectedPinCount");
        }
        this.pinConfigs = new byte[13];
        System.arraycopy(pinConfigs, 0, this.pinConfigs, 0, this.pinConfigs.length);
        this.useUartSuspendValues = useUartSuspendValues;
        this.useGPIOSuspendValues = useGPIOSuspendValues;
        this.suspendValue = suspendValue;
        this.resetValue = resetValue;
        this.latchControl = latchControl;
        this.enableWeakPullUp = enableWeakPullUp;
        this.rs485Invert = rs485Invert;
    }

    public CP2103_4PinConfig(byte[] portConfigStruct) {
        if (portConfigStruct.length < 7) {
            throw new IllegalArgumentException("portConfig.length != PORT_CONFIG_SIZE");
        }
        this.pinConfigs = new byte[13];
        int mode = (portConfigStruct[0] | portConfigStruct[1] << 8) & 0xFFFF;
        this.pinConfigs[0] = (byte)((1 & mode) != 0 ? 1 : 0);
        this.pinConfigs[1] = (byte)((2 & mode) != 0 ? 1 : 0);
        this.pinConfigs[2] = (byte)((4 & mode) != 0 ? 1 : 0);
        this.pinConfigs[3] = (byte)((8 & mode) != 0 ? 1 : 0);
        this.pinConfigs[4] = (byte)((0x10 & mode) != 0 ? 1 : 0);
        this.pinConfigs[5] = (byte)((0x40 & mode) != 0 ? 1 : 0);
        this.pinConfigs[6] = (byte)((0x80 & mode) != 0 ? 1 : 0);
        this.pinConfigs[7] = (byte)((0x4000 & mode) != 0 ? 1 : 0);
        this.pinConfigs[8] = (byte)((0x8000 & mode) != 0 ? 1 : 0);
        this.pinConfigs[9] = (byte)((0x100 & mode) != 0 ? 1 : 0);
        this.pinConfigs[10] = (byte)((0x200 & mode) != 0 ? 1 : 0);
        this.pinConfigs[11] = (byte)((0x400 & mode) != 0 ? 1 : 0);
        this.pinConfigs[12] = (byte)((0x800 & mode) != 0 ? 1 : 0);
        this.resetValue = portConfigStruct[2] & 0xFF | (portConfigStruct[3] & 0xFF) << 8;
        this.suspendValue = (portConfigStruct[4] & 0xFF | (portConfigStruct[5] & 0xFF) << 8) & 0xFFFF;
        this.useUartSuspendValues = (portConfigStruct[6] & 0x40) != 0 ? 1 : 0;
        this.useGPIOSuspendValues = (portConfigStruct[6] & 0x80) != 0 ? 1 : 0;
        this.enableWeakPullUp = (portConfigStruct[6] & 0x10) != 0 ? 1 : 0;
        this.rs485Invert = (portConfigStruct[6] & 8) != 0 ? 1 : 0;
        if ((portConfigStruct[6] & 1) != 0) {
            this.latchControl |= 0x100;
        }
        if ((portConfigStruct[6] & 2) != 0) {
            this.latchControl |= 0x200;
        }
        if ((portConfigStruct[6] & 4) != 0) {
            this.latchControl |= 0x400;
        }
    }

    public String toString() {
        return String.format("PinConfig [pinConfig=%s, resetValue, suspendValue, useUartSuspendValues=%X, useGPIOSuspendValues=%X, enableWeakPullUp=%X, rs485Invert=%X]", Arrays.toString(this.pinConfigs), this.suspendValue, this.useUartSuspendValues, this.useGPIOSuspendValues, this.enableWeakPullUp, this.rs485Invert);
    }

    public byte[] getConfigStruct() {
        byte[] portConfigStruct = new byte[7];
        int mode = 0;
        mode |= this.pinConfigs[0] != 0 ? 1 : 0;
        mode |= this.pinConfigs[1] != 0 ? 2 : 0;
        mode |= this.pinConfigs[2] != 0 ? 4 : 0;
        mode |= this.pinConfigs[3] != 0 ? 8 : 0;
        mode |= this.pinConfigs[4] != 0 ? 16 : 0;
        mode |= this.pinConfigs[5] != 0 ? 64 : 0;
        mode |= this.pinConfigs[6] != 0 ? 128 : 0;
        mode |= this.pinConfigs[7] != 0 ? 16384 : 0;
        mode |= this.pinConfigs[8] != 0 ? 32768 : 0;
        mode |= this.pinConfigs[9] != 0 ? 256 : 0;
        mode |= this.pinConfigs[10] != 0 ? 512 : 0;
        mode |= this.pinConfigs[11] != 0 ? 1024 : 0;
        portConfigStruct[0] = (byte)((mode |= this.pinConfigs[12] != 0 ? 2048 : 0) & 0xFF);
        portConfigStruct[1] = (byte)((mode & 0xFF00) >> 8);
        portConfigStruct[2] = (byte)(this.resetValue & 0xFF);
        portConfigStruct[3] = (byte)((this.resetValue & 0xFF00) >> 8);
        portConfigStruct[4] = (byte)(this.suspendValue & 0xFF);
        portConfigStruct[5] = (byte)((this.suspendValue & 0xFF00) >> 8);
        if (this.useUartSuspendValues != 0) {
            portConfigStruct[6] = (byte)(portConfigStruct[6] | 0x40);
        }
        if (this.useGPIOSuspendValues != 0) {
            portConfigStruct[6] = (byte)(portConfigStruct[6] | 0x80);
        }
        if (this.enableWeakPullUp != 0) {
            portConfigStruct[6] = (byte)(portConfigStruct[6] | 0x10);
        }
        if (this.rs485Invert != 0) {
            portConfigStruct[6] = (byte)(portConfigStruct[6] | 8);
        }
        if ((this.latchControl & 0x100) != 0) {
            portConfigStruct[6] = (byte)(portConfigStruct[6] | 1);
        }
        if ((this.latchControl & 0x200) != 0) {
            portConfigStruct[6] = (byte)(portConfigStruct[6] | 2);
        }
        if ((this.latchControl & 0x400) != 0) {
            portConfigStruct[6] = (byte)(portConfigStruct[6] | 4);
        }
        return portConfigStruct;
    }
}

