/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.customizer.devices.cp210x;

import com.silabs.customizer.devices.Device;
import com.silabs.customizer.devices.DeviceDetector;
import com.silabs.customizer.devices.Property;
import com.silabs.customizer.devices.PropertyFlushBuffers;
import com.silabs.customizer.devices.PropertyLockValue;
import com.silabs.customizer.devices.PropertyPID;
import com.silabs.customizer.devices.PropertyPower;
import com.silabs.customizer.devices.PropertyPowerMode;
import com.silabs.customizer.devices.PropertyProductDescr;
import com.silabs.customizer.devices.PropertyReleaseVer;
import com.silabs.customizer.devices.PropertySerial;
import com.silabs.customizer.devices.PropertyVID;
import com.silabs.customizer.devices.cp210x.CP2103_4GroupPortConfigRoot;
import com.silabs.customizer.devices.cp210x.CP2103_4PinConfig;
import com.silabs.customizer.devices.cp210x.CP210xManufacturing;
import com.silabs.customizer.devices.cp210x.Device210x;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.ByteByReference;
import com.sun.jna.ptr.IntByReference;

final class Device2104
extends Device210x {
    Device2104(String serial, String deviceString) {
        super(serial, deviceString);
        this.setOTP(true);
        this.setShowConfigureIds(true);
        this.setShowConfigureBaudRate(false);
        this.setShowConfigurePins(true);
    }

    @Override
    public String getType() {
        return "CP2104";
    }

    @Override
    protected synchronized Property[] createIds() {
        DeviceDetector.getDefault().stop();
        Property[] result = new Property[]{new PropertyVID(this), new PropertyPID(this), new PropertyPower(this), new PropertyPowerMode(this), new PropertyReleaseVer(this), new PropertyFlushBuffers(this, 1), new PropertyProductDescr(this), new PropertySerial(this, maxSerialStrlen), new PropertyLockValue(this)};
        DeviceDetector.getDefault().start();
        return result;
    }

    public static synchronized void setPinConfig(Device deviceObj, CP2103_4PinConfig writeConfig) throws Exception {
        Device2104.checkDeviceDetection();
        if (writeConfig.pinConfigs.length != 13) {
            throw new IllegalStateException("Error in number of configurable pins!");
        }
        Pointer device = Device2104.openDevice((Device210x)deviceObj);
        int status = CP210xManufacturing.DLL.CP210x_SetPortConfig(device, writeConfig.getConfigStruct());
        Device2104.close(device);
        LOG.logDebug(status, "setPinConfig", writeConfig);
        if (status != 0) {
            throw new Exception("setPinconfig(" + deviceObj + "): " + status);
        }
    }

    protected static synchronized CP2103_4PinConfig getPinConfig(Device deviceObj) throws Exception {
        Device2104.checkDeviceDetection();
        Pointer device = Device2104.openDevice((Device210x)deviceObj);
        byte[] portConfig = new byte[7];
        int status = CP210xManufacturing.DLL.CP210x_GetPortConfig(device, portConfig);
        Device2104.close(device);
        CP2103_4PinConfig result = new CP2103_4PinConfig(portConfig);
        LOG.logDebug(status, "getPinConfig", result);
        if (status != 0) {
            throw new Exception("getPinConfig(" + deviceObj + "): " + status);
        }
        return result;
    }

    @Override
    protected synchronized Property[] createPortConfigs() {
        DeviceDetector.getDefault().stop();
        DeviceDetector.getDefault().stop();
        Property[] result = new Property[]{new CP2103_4GroupPortConfigRoot(this)};
        DeviceDetector.getDefault().start();
        return result;
    }

    @Override
    public String getFlushBuffers(Device deviceObj) throws Exception {
        Device2104.checkDeviceDetection();
        Pointer device = Device2104.openDevice((Device210x)deviceObj);
        IntByReference flushBuffers = new IntByReference();
        int status = CP210xManufacturing.DLL.CP210x_GetFlushBufferConfig(device, flushBuffers);
        Device2104.close(device);
        String result = status == 0 ? Device2104.toHexString(flushBuffers.getValue(), 4) : "";
        LOG.logDebug(status, "getFlushBuffers:", result);
        if (status != 0) {
            throw new Exception("getFlushBuffers(" + deviceObj + "): " + status);
        }
        return result;
    }

    @Override
    public void setFlushBuffers(Device deviceObj, String value) throws Exception {
        Device2104.checkDeviceDetection();
        Pointer device = Device2104.openDevice((Device210x)deviceObj);
        long flushBuffers = Long.parseLong(value, 16);
        int status = CP210xManufacturing.DLL.CP210x_SetFlushBufferConfig(device, flushBuffers);
        Device2104.close(device);
        LOG.logDebug(status, "setFlushBuffers:", value);
        if (status != 0) {
            throw new Exception("setFlushBuffers(" + deviceObj + "): " + status);
        }
    }

    @Override
    public String getLockValue(Device deviceObj) throws Exception {
        Device2104.checkDeviceDetection();
        Pointer device = Device2104.openDevice((Device210x)deviceObj);
        ByteByReference lockValue = new ByteByReference();
        int status = CP210xManufacturing.DLL.CP210x_GetLockValue(device, lockValue);
        Device2104.close(device);
        String result = status == 0 ? Device2104.toHexString(lockValue.getValue(), 2) : "";
        LOG.logDebug(status, "getLockByte:", result);
        if (status != 0) {
            throw new Exception("getLockByte(" + deviceObj + "): " + status);
        }
        return result;
    }

    @Override
    public void setLockValue(Device deviceObj, String value) throws Exception {
        Device2104.checkDeviceDetection();
        Pointer device = Device2104.openDevice((Device210x)deviceObj);
        int status = CP210xManufacturing.DLL.CP210x_SetLockValue(device);
        Device2104.close(device);
        LOG.logDebug(status, "setLockByte:", value);
        if (status != 0) {
            throw new Exception("setLockByte(" + deviceObj + "): " + status);
        }
    }

    @Override
    public final void resetSiliconLabsDefaultValues() {
        Property[] idProps = this.getIds();
        idProps[0].reset("10C4");
        idProps[1].reset("EA60");
        idProps[2].reset("32");
        idProps[3].reset("00");
        idProps[4].reset("0100");
        idProps[5].reset("0005");
        idProps[6].reset("Silicon Laboratories");
        idProps[7].reset("CP2104 USB to UART Bridge Controller");
        idProps[9].reset("00");
        Property[] portConfigProps = this.getPortConfigs();
        CP2103_4GroupPortConfigRoot cp2104PortConfigRoot = (CP2103_4GroupPortConfigRoot)portConfigProps[0];
        cp2104PortConfigRoot.resetSiliconLabsDefaultValues();
    }
}

