/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.customizer.devices.cp210x;

import com.silabs.customizer.devices.Device;
import com.silabs.customizer.devices.DeviceDetector;
import com.silabs.customizer.devices.Property;
import com.silabs.customizer.devices.PropertyFlushBuffers;
import com.silabs.customizer.devices.PropertyInterfaceString;
import com.silabs.customizer.devices.PropertyLockValue;
import com.silabs.customizer.devices.PropertyManufacturer;
import com.silabs.customizer.devices.PropertyPID;
import com.silabs.customizer.devices.PropertyPower;
import com.silabs.customizer.devices.PropertyPowerMode;
import com.silabs.customizer.devices.PropertyProductDescr;
import com.silabs.customizer.devices.PropertyReleaseVer;
import com.silabs.customizer.devices.PropertySerial;
import com.silabs.customizer.devices.PropertyVID;
import com.silabs.customizer.devices.cp210x.CP2108GroupPortConfigRoot;
import com.silabs.customizer.devices.cp210x.CP2108PinConfig;
import com.silabs.customizer.devices.cp210x.CP210xManufacturing;
import com.silabs.customizer.devices.cp210x.Device210x;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.ByteByReference;
import com.sun.jna.ptr.IntByReference;
import java.util.Arrays;

final class Device2108
extends Device210x {
    Device2108(String serial, String deviceString) {
        super(serial, deviceString);
        this.maxProductStrlen = 126;
        maxSerialStrlen = 63;
        this.maxInterfaceStrlen = 43;
        this.setShowConfigureIds(true);
        this.setShowConfigureBaudRate(false);
        this.setShowConfigurePins(true);
    }

    @Override
    public String getType() {
        return "CP2108";
    }

    @Override
    protected synchronized Property[] createIds() {
        DeviceDetector.getDefault().stop();
        Property[] result = new Property[]{new PropertyVID(this), new PropertyPID(this), new PropertyPower(this), new PropertyPowerMode(this), new PropertyReleaseVer(this), new PropertyFlushBuffers(this, 4), new PropertyManufacturer(this), new PropertyProductDescr(this), new PropertyInterfaceString(this, 0), new PropertyInterfaceString(this, 1), new PropertyInterfaceString(this, 2), new PropertyInterfaceString(this, 3), new PropertySerial(this, maxSerialStrlen), new PropertyLockValue(this)};
        DeviceDetector.getDefault().start();
        return result;
    }

    public static synchronized void setPinConfig(Device deviceObj, CP2108PinConfig writeConfig) throws Exception {
        Device2108.checkDeviceDetection();
        Pointer device = Device2108.openDevice((Device210x)deviceObj);
        int status = CP210xManufacturing.DLL.CP210x_SetQuadPortConfig(device, writeConfig.getConfigStruct());
        Device2108.close(device);
        LOG.logDebug(status, "setPinConfig", writeConfig);
        if (status != 0) {
            throw new Exception("setPinconfig(" + deviceObj + "): " + status);
        }
    }

    protected static synchronized CP2108PinConfig getPinConfig(Device deviceObj) throws Exception {
        Device2108.checkDeviceDetection();
        Pointer device = Device2108.openDevice((Device210x)deviceObj);
        byte[] portConfig = new byte[73];
        int status = CP210xManufacturing.DLL.CP210x_GetQuadPortConfig(device, portConfig);
        Device2108.close(device);
        CP2108PinConfig result = new CP2108PinConfig(portConfig);
        LOG.logDebug(status, "getPinConfig", result);
        if (status != 0) {
            throw new Exception("getPinConfig(" + deviceObj + "): " + status);
        }
        return result;
    }

    @Override
    protected synchronized Property[] createPortConfigs() {
        DeviceDetector.getDefault().stop();
        Property[] result = new Property[]{new CP2108GroupPortConfigRoot(this)};
        DeviceDetector.getDefault().start();
        return result;
    }

    @Override
    public synchronized String getManufacturer(Device deviceObj) throws Exception {
        Device2108.checkDeviceDetection();
        Pointer device = Device2108.openDevice((Device210x)deviceObj);
        byte[] manufacturingString = new byte[this.maxManufacturerStrlen];
        ByteByReference strlen = new ByteByReference();
        int status = CP210xManufacturing.DLL.CP210x_GetDeviceManufacturerString(device, manufacturingString, strlen, true);
        Device2108.close(device);
        String result = status == 0 ? Native.toString((byte[])manufacturingString) : "";
        LOG.logDebug(status, "getManufacturer:", result);
        if (status != 0) {
            throw new Exception("getManufacturer(" + deviceObj + "): " + status);
        }
        return result;
    }

    @Override
    public synchronized void setManufacturer(Device deviceObj, String manufacturer) throws Exception {
        Device2108.checkDeviceDetection();
        Pointer device = Device2108.openDevice((Device210x)deviceObj);
        byte[] manuStr = Native.toByteArray((String)manufacturer);
        int status = 2;
        if (manuStr.length < this.maxManufacturerStrlen) {
            status = CP210xManufacturing.DLL.CP210x_SetManufacturerString(device, manuStr, (byte)manuStr.length, true);
        }
        Device2108.close(device);
        LOG.logDebug(status, "setManufacturer:", Arrays.toString(manuStr));
        if (status != 0) {
            throw new Exception("setManufacturer(" + deviceObj + "): " + status);
        }
    }

    @Override
    public String getInterfaceString(Device deviceObj, int interfaceNumber) throws Exception {
        Device2108.checkDeviceDetection();
        Pointer device = Device2108.openDevice((Device210x)deviceObj);
        byte[] interfaceString = new byte[this.maxInterfaceStrlen];
        ByteByReference strlen = new ByteByReference();
        int status = CP210xManufacturing.DLL.CP210x_GetDeviceInterfaceString(device, (byte)interfaceNumber, interfaceString, strlen, true);
        Device2108.close(device);
        String result = status == 0 ? Native.toString((byte[])interfaceString) : "";
        LOG.logDebug(status, "getProduct:", result);
        if (status != 0) {
            throw new Exception("getProduct(" + deviceObj + "): " + status);
        }
        return result;
    }

    @Override
    public void setInterfaceString(Device deviceObj, int interfaceNumber, String interfaceString) throws Exception {
        Device2108.checkDeviceDetection();
        Pointer device = Device2108.openDevice((Device210x)deviceObj);
        byte[] ifcStr = Native.toByteArray((String)interfaceString);
        int status = 2;
        if (ifcStr.length < this.maxInterfaceStrlen) {
            byte strlen = (byte)ifcStr.length;
            status = CP210xManufacturing.DLL.CP210x_SetInterfaceString(device, (byte)interfaceNumber, ifcStr, strlen, true);
        }
        Device2108.close(device);
        LOG.logDebug(status, "setProduct:", Arrays.toString(ifcStr));
        if (status != 0) {
            throw new Exception("setProduct(" + deviceObj + "): " + status);
        }
    }

    @Override
    public final synchronized String getFlushBuffers(Device deviceObj) throws Exception {
        Device2108.checkDeviceDetection();
        Pointer device = Device2108.openDevice((Device210x)deviceObj);
        IntByReference flushBuffers = new IntByReference();
        int status = CP210xManufacturing.DLL.CP210x_GetFlushBufferConfig(device, flushBuffers);
        Device2108.close(device);
        String result = status == 0 ? Device2108.toHexString(flushBuffers.getValue(), 4) : "";
        LOG.logDebug(status, "getFlushBuffers:", result);
        if (status != 0) {
            throw new Exception("getFlushBuffers(" + deviceObj + "): " + status);
        }
        return result;
    }

    @Override
    public synchronized void setFlushBuffers(Device deviceObj, String value) throws Exception {
        Device2108.checkDeviceDetection();
        Pointer device = Device2108.openDevice((Device210x)deviceObj);
        long flushBuffers = Long.parseLong(value, 16);
        int status = CP210xManufacturing.DLL.CP210x_SetFlushBufferConfig(device, flushBuffers);
        Device2108.close(device);
        LOG.logDebug(status, "setFlushBuffers:", value);
        if (status != 0) {
            throw new Exception("setFlushBuffers(" + deviceObj + "): " + status);
        }
    }

    @Override
    public String getLockValue(Device deviceObj) throws Exception {
        Device2108.checkDeviceDetection();
        Pointer device = Device2108.openDevice((Device210x)deviceObj);
        ByteByReference lockValue = new ByteByReference();
        int status = CP210xManufacturing.DLL.CP210x_GetLockValue(device, lockValue);
        Device2108.close(device);
        String result = status == 0 ? Device2108.toHexString(lockValue.getValue(), 2) : "";
        LOG.logDebug(status, "getLockByte:", result);
        if (status != 0) {
            throw new Exception("getLockByte(" + deviceObj + "): " + status);
        }
        return result;
    }

    @Override
    public void setLockValue(Device deviceObj, String value) throws Exception {
        Device2108.checkDeviceDetection();
        Pointer device = Device2108.openDevice((Device210x)deviceObj);
        int status = CP210xManufacturing.DLL.CP210x_SetLockValue(device);
        Device2108.close(device);
        LOG.logDebug(status, "setLockByte:", value);
        if (status != 0) {
            throw new Exception("setLockByte(" + deviceObj + "): " + status);
        }
    }

    @Override
    public final void resetSiliconLabsDefaultValues() {
        Property[] idProps = this.getIds();
        idProps[0].reset("10C4");
        idProps[1].reset("EA71");
        idProps[2].reset("32");
        idProps[3].reset("00");
        idProps[4].reset("0140");
        idProps[5].reset("3333");
        idProps[6].reset("Silicon Labs");
        idProps[7].reset("CP2108 Quad USB to UART Bridge Controller");
        idProps[8].reset("CP2108 Interface 0");
        idProps[9].reset("CP2108 Interface 1");
        idProps[10].reset("CP2108 Interface 2");
        idProps[11].reset("CP2108 Interface 3");
        idProps[13].reset("00");
        Property[] portConfigProps = this.getPortConfigs();
        CP2108GroupPortConfigRoot cp2108PortConfigRoot = (CP2108GroupPortConfigRoot)portConfigProps[0];
        cp2108PortConfigRoot.resetSiliconLabsDefaultValues();
    }
}

