/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.customizer.devices.cp211x;

import java.util.Arrays;

public final class CP2114PinConfig {
    public static final int expectedPinCount = 14;
    final byte[] pinConfigs;
    final int useSuspendValues;
    final int suspendValue;
    final int suspendMode;
    final short clkDiv;

    CP2114PinConfig(byte[] pinConfigs, int useSuspendValues, int suspendValue, int suspendMode, short clkDiv) {
        if (pinConfigs.length != 14) {
            throw new IllegalArgumentException("pinConfig.length != expectedPinCount");
        }
        this.pinConfigs = new byte[14];
        System.arraycopy(pinConfigs, 0, this.pinConfigs, 0, this.pinConfigs.length);
        this.useSuspendValues = useSuspendValues;
        this.suspendValue = suspendValue;
        this.suspendMode = suspendMode;
        this.clkDiv = clkDiv;
    }

    public String toString() {
        return String.format("PinConfig [pinConfig=%s, useSuspendValues=%X, suspendValue=%04X, suspendMode=%04X, clkDiv=%02X]", Arrays.toString(this.pinConfigs), this.useSuspendValues, this.suspendValue, this.suspendMode, this.clkDiv);
    }

    public boolean useSupendValues() {
        return this.useSuspendValues != 0;
    }
}

