/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.customizer.devices.cp261x;

import com.silabs.customizer.devices.Device;
import com.silabs.customizer.devices.Item;
import com.silabs.customizer.devices.Property;
import java.util.Locale;

public class PropertyEASerialProtocolEnable
extends Property {
    public PropertyEASerialProtocolEnable(Device device) {
        super(device, null, "Enable EA Serial Protocol", new Item[]{new Item("0", String.format("No", new Object[0])), new Item("1", String.format("Yes", new Object[0]))});
        this.initBitMask(4, "CFG_FLAG_ENABLE_EAPROTO_SER");
        this.initProperty();
    }

    @Override
    public void setDefaultValue(String value) {
        super.setDefaultValue(value.toUpperCase(Locale.ENGLISH));
    }

    @Override
    public void setValue(String value) {
        try {
            super.setValue(value);
        }
        catch (NumberFormatException numberFormatException) {}
    }

    @Override
    protected String readValueFromDevice() throws Exception {
        return "0";
    }

    public String getSerialInterfaceXML() {
        String xmlString = "      ";
        if (this.getValue() == "1") {
            xmlString = String.valueOf(xmlString) + "      <descriptor type=\"interface\">\n";
            xmlString = String.valueOf(xmlString) + "        <comment>EA serial protocol interface descriptor</comment>\n";
            xmlString = String.valueOf(xmlString) + "        <field name=\"bLength\" size=\"1\">                      <value>9</value>        </field>\n";
            xmlString = String.valueOf(xmlString) + "        <field name=\"bDescriptorType\" size=\"1\" type=\"subst\"> <value>INTERFACE</value></field>\n";
            xmlString = String.valueOf(xmlString) + "        <field name=\"bInterfaceNumber\" size=\"1\">             <value>4</value>        </field>\n";
            xmlString = String.valueOf(xmlString) + "        <field name=\"bAlternateSetting\" size=\"1\">            <value>0</value>        </field>\n";
            xmlString = String.valueOf(xmlString) + "        <field name=\"bNumEndpoints\" size=\"1\">                <value>0</value>        </field>\n";
            xmlString = String.valueOf(xmlString) + "        <field name=\"bInterfaceClass\" size=\"1\">              <value>0xFF</value>     </field>\n";
            xmlString = String.valueOf(xmlString) + "        <field name=\"bInterfaceSubClass\" size=\"1\">           <value>0xF0</value>     </field>\n";
            xmlString = String.valueOf(xmlString) + "        <field name=\"bInterfaceProtocol\" size=\"1\">           <value>1</value>        </field>\n";
            xmlString = String.valueOf(xmlString) + "        <field name=\"iInterface\" size=\"1\">                   <value>5</value>        </field>\n";
            xmlString = String.valueOf(xmlString) + "        \n";
            xmlString = String.valueOf(xmlString) + "        <field name=\"bLength\" size=\"1\">                      <value>9</value>        </field>\n";
            xmlString = String.valueOf(xmlString) + "        <field name=\"bDescriptorType\" size=\"1\" type=\"subst\"> <value>INTERFACE</value></field>\n";
            xmlString = String.valueOf(xmlString) + "        <field name=\"bInterfaceNumber\" size=\"1\">             <value>4</value>        </field>\n";
            xmlString = String.valueOf(xmlString) + "        <field name=\"bAlternateSetting\" size=\"1\">            <value>1</value>        </field>\n";
            xmlString = String.valueOf(xmlString) + "        <field name=\"bNumEndpoints\" size=\"1\">                <value>2</value>        </field>\n";
            xmlString = String.valueOf(xmlString) + "        <field name=\"bInterfaceClass\" size=\"1\">              <value>0xFF</value>     </field>\n";
            xmlString = String.valueOf(xmlString) + "        <field name=\"bInterfaceSubClass\" size=\"1\">           <value>0xF0</value>     </field>\n";
            xmlString = String.valueOf(xmlString) + "        <field name=\"bInterfaceProtocol\" size=\"1\">           <value>1</value>        </field>\n";
            xmlString = String.valueOf(xmlString) + "        <field name=\"iInterface\" size=\"1\">                   <value>5</value>        </field>\n";
            xmlString = String.valueOf(xmlString) + "        <descriptor type=\"endpoint\">\n";
            xmlString = String.valueOf(xmlString) + "          <comment>EAP serial bulk IN endpoint</comment>\n";
            xmlString = String.valueOf(xmlString) + "          <field name=\"bLength\" size=\"1\">                      <value>7</value>        </field>\n";
            xmlString = String.valueOf(xmlString) + "          <field name=\"bDescriptorType\" size=\"1\" type=\"subst\"> <value>ENDPOINT</value> </field>\n";
            xmlString = String.valueOf(xmlString) + "          <field name=\"bEndpointAddress\" size=\"1\">\n";
            xmlString = String.valueOf(xmlString) + "            <comment>Endpoint 2</comment>\n";
            xmlString = String.valueOf(xmlString) + "            <value>0x82</value>\n";
            xmlString = String.valueOf(xmlString) + "          </field>\n";
            xmlString = String.valueOf(xmlString) + "          <field name=\"bmAttributes\" size=\"1\"><comment>bulk</comment><value>2</value>  </field>\n";
            xmlString = String.valueOf(xmlString) + "          <field name=\"wMaxPacketSize\" size=\"2\" type=\"dec\" order=\"le\"><value>32</value></field>\n";
            xmlString = String.valueOf(xmlString) + "          <field name=\"bInterval\" size=\"1\">                    <value>0</value>        </field>\n";
            xmlString = String.valueOf(xmlString) + "        </descriptor>\n";
            xmlString = String.valueOf(xmlString) + "        <descriptor type=\"endpoint\">\n";
            xmlString = String.valueOf(xmlString) + "          <comment>EAP serial bulk OUT endpoint</comment>\n";
            xmlString = String.valueOf(xmlString) + "          <field name=\"bLength\" size=\"1\">                      <value>7</value>        </field>\n";
            xmlString = String.valueOf(xmlString) + "          <field name=\"bDescriptorType\" size=\"1\" type=\"subst\"> <value>ENDPOINT</value> </field>\n";
            xmlString = String.valueOf(xmlString) + "          <field name=\"bEndpointAddress\" size=\"1\">\n";
            xmlString = String.valueOf(xmlString) + "            <comment>Endpoint 2</comment>\n";
            xmlString = String.valueOf(xmlString) + "            <value>0x02</value>\n";
            xmlString = String.valueOf(xmlString) + "          </field>\n";
            xmlString = String.valueOf(xmlString) + "          <field name=\"bmAttributes\" size=\"1\"><comment>bulk</comment><value>2</value>  </field>\n";
            xmlString = String.valueOf(xmlString) + "          <field name=\"wMaxPacketSize\" size=\"2\" type=\"dec\" order=\"le\"><value>32</value></field>\n";
            xmlString = String.valueOf(xmlString) + "          <field name=\"bInterval\" size=\"1\">                    <value>0</value>        </field>\n";
            xmlString = String.valueOf(xmlString) + "        </descriptor>\n";
            xmlString = String.valueOf(xmlString) + "      </descriptor>\n";
        }
        return xmlString;
    }

    public String getEaSerialProtocolXML(String protocolString) {
        String xmlString = "";
        if (this.getValue() == "1") {
            xmlString = String.valueOf(xmlString) + "    <parametergroup name=\"eaProtocolGroup\" id=\"10\">\n";
            xmlString = String.valueOf(xmlString) + "      <comment>Serial Protocol definition</comment>\n";
            xmlString = String.valueOf(xmlString) + "      <parameter name=\"eaProtocolIdParm\" id=\"0\">\n";
            xmlString = String.valueOf(xmlString) + "        <comment>SER protocol ID is 2</comment>\n";
            xmlString = String.valueOf(xmlString) + "        <field name=\"eaProtocolId\" type=\"num\" size=\"1\"><value>2</value></field>\n";
            xmlString = String.valueOf(xmlString) + "      </parameter>\n";
            xmlString = String.valueOf(xmlString) + "      <parameter name=\"eaProtocolNameParm\" id=\"1\">\n";
            xmlString = String.valueOf(xmlString) + "        <field name=\"eaProtocolNameUtf8\" type=\"utf8\">\n";
            xmlString = String.valueOf(xmlString) + "          <value>";
            xmlString = String.valueOf(xmlString) + protocolString;
            xmlString = String.valueOf(xmlString) + "</value>\n";
            xmlString = String.valueOf(xmlString) + "        </field>\n";
            xmlString = String.valueOf(xmlString) + "      </parameter>\n";
            xmlString = String.valueOf(xmlString) + "      <parameter name=\"eaProtocolMatchParm\" id=\"2\">\n";
            xmlString = String.valueOf(xmlString) + "        <comment>match action is none</comment>\n";
            xmlString = String.valueOf(xmlString) + "        <field name=\"eaProtocolMatchAction\" type=\"num\" size=\"1\"><value>0</value></field>\n";
            xmlString = String.valueOf(xmlString) + "      </parameter>\n";
            xmlString = String.valueOf(xmlString) + "      <parameter name=\"eaProtocolNativeTransportParm\" id=\"3\">\n";
            xmlString = String.valueOf(xmlString) + "        <field name=\"eaProtocolTransportId\" type=\"num\" size=\"2\" order=\"be\"><value>1</value></field>\n";
            xmlString = String.valueOf(xmlString) + "      </parameter>\n";
            xmlString = String.valueOf(xmlString) + "    </parametergroup>";
        }
        return xmlString;
    }
}

