/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.customizer.actions;

import com.silabs.customizer.devices.Device;
import com.silabs.customizer.devices.DeviceNone;
import com.silabs.customizer.devices.IDeviceVisitor;
import com.silabs.customizer.devices.Property;
import com.silabs.customizer.devices.PropertyGroup;
import com.silabs.customizer.preferences.GeneralPreferences;
import com.silabs.customizer.preferences.PreferenceConstants;
import com.silabs.customizer.preferences.SerialNumberPreferences;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Shell;

public class PreferencesAction
extends Action
implements ISelectionChangedListener,
IDeviceVisitor {
    private final Shell shell;
    private final List<Viewer> viewers = new LinkedList<Viewer>();
    private Device device;

    public PreferencesAction(Shell shell) {
        super("&Preferences...");
        this.shell = shell;
        this.setId(PreferencesAction.class.getName());
    }

    @Override
    public void accept(Property property) {
        String auto;
        if (property.isSerial() && (auto = PreferenceConstants.getSerial()) != null && !auto.equals(property.getValue())) {
            property.setValue(auto);
        }
    }

    public void addViewer(Viewer viewer) {
        if (viewer != null) {
            this.viewers.add(viewer);
        }
    }

    @Override
    public void enter(Device device) {
    }

    @Override
    public void enter(PropertyGroup group) {
    }

    @Override
    public void leave(Device device) {
    }

    @Override
    public void leave(PropertyGroup group) {
    }

    public void removeViewer(Viewer viewer) {
        if (viewer != null) {
            this.viewers.remove(viewer);
        }
    }

    public void run() {
        PreferenceManager manager = new PreferenceManager();
        manager.addToRoot(GeneralPreferences.createNode());
        manager.addToRoot(SerialNumberPreferences.createNode());
        PreferenceDialog dialog = new PreferenceDialog(this.shell, manager);
        dialog.open();
        this.updateDevice();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection sSelection = (IStructuredSelection)selection;
            Object first = sSelection.getFirstElement();
            if (first instanceof Device && !(first instanceof DeviceNone)) {
                this.device = (Device)first;
                this.updateDevice();
            } else {
                this.device = null;
            }
        }
    }

    private void updateDevice() {
        if (PreferenceConstants.isAutoIncrementSerial() && this.device != null) {
            this.device.visit(this);
            for (Viewer viewer : this.viewers) {
                viewer.refresh();
            }
        }
    }
}

