/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.customizer.devices;

import com.silabs.customizer.devices.CellEditorFactory;
import com.silabs.customizer.devices.GenericValueDialog;
import com.silabs.customizer.devices.GenericValueDialogButton;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public final class GenericCellEditor
extends DialogCellEditor {
    String title;
    String description;
    GenericValueDialogButton[] buttons;
    int valueSize;

    public static CellEditorFactory getFactory(final String title, final String description, final GenericValueDialogButton[] buttons, final int valueSize) {
        return new CellEditorFactory(){

            @Override
            public CellEditor create(Composite parent, Object value) {
                GenericCellEditor result = new GenericCellEditor(parent, title, description, buttons, valueSize);
                result.setValue(value);
                return result;
            }
        };
    }

    GenericCellEditor(Composite parent, String title, String description, GenericValueDialogButton[] buttons, int valueSize) {
        super(parent);
        this.title = title;
        this.description = description;
        this.buttons = buttons;
        this.valueSize = valueSize;
    }

    protected Object openDialogBox(Control parent, String title, String description, GenericValueDialogButton[] buttons) {
        String result = null;
        GenericValueDialog dialog = new GenericValueDialog(parent.getShell(), title, description, (String)this.getValue(), this.valueSize, buttons);
        dialog.setValue((String)this.getValue(), this.valueSize);
        if (dialog.open() == 0) {
            result = dialog.getValue();
        }
        return result;
    }

    protected Object openDialogBox(Control cellEditorWindow) {
        return this.openDialogBox(cellEditorWindow, this.title, this.description, this.buttons);
    }
}

