/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.customizer.devices;

import com.silabs.customizer.devices.Device;
import com.silabs.customizer.devices.IDeviceVisitor;
import com.silabs.customizer.devices.Property;
import com.silabs.customizer.devices.PropertyGroup;
import com.silabs.customizer.devices.PropertyInterfaceString;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

abstract class IOVisitor
implements IDeviceVisitor {
    public static final String KEY_DEVICE = "device";
    public static final String KEY_VERSION = "version";
    public static final String SAVE_VERSION = "2";
    private Stack<String> groups;
    private Map<String, Integer> groupIndices;

    IOVisitor() {
    }

    @Override
    public final void accept(Property property) {
        this.accept(property, this.getKey(property));
    }

    @Override
    public void enter(Device device) {
        this.groups = new Stack();
        this.groupIndices = new HashMap<String, Integer>();
    }

    @Override
    public final void enter(PropertyGroup group) {
        String grpName = this.getName(group);
        this.groups.push(grpName);
        this.groupIndices.put(grpName, 0);
    }

    @Override
    public void leave(Device device) {
    }

    @Override
    public final void leave(PropertyGroup group) {
        this.groups.pop();
        this.groupIndices.remove(this.getName(group));
    }

    protected abstract void accept(Property var1, String var2);

    private String getGroupPrefixKey() {
        StringBuilder result = new StringBuilder();
        Enumeration iter = this.groups.elements();
        while (iter.hasMoreElements()) {
            result.append((String)iter.nextElement());
            result.append("/");
        }
        return result.toString();
    }

    private String getKey(Property property) {
        String group = this.groups.isEmpty() ? null : this.groups.peek();
        int index = -1;
        if (group != null) {
            index = this.groupIndices.get(group);
            this.groupIndices.put(group, index + 1);
        }
        String key = group != null ? String.format("%s%s/%d", this.getGroupPrefixKey(), this.getName(property), index) : this.getName(property);
        return key;
    }

    private String getName(Property property) {
        String name = property.getClass().getSimpleName();
        if (name.equals("PropertyInterfaceString")) {
            name = String.format("%s%d", name, ((PropertyInterfaceString)property).getInterfaceNumber());
        }
        return name;
    }
}

