/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.customizer.devices.cp210x;

import com.silabs.customizer.devices.Device;
import com.silabs.customizer.devices.GenericCellEditor;
import com.silabs.customizer.devices.GenericValueDialogButton;
import com.silabs.customizer.devices.GroupInterface;
import com.silabs.customizer.devices.Property;
import com.silabs.customizer.devices.PropertyClockDivider;
import com.silabs.customizer.devices.PropertyGenericEdit;
import com.silabs.customizer.devices.PropertyIPDelay;
import com.silabs.customizer.devices.PropertyToggleValues;

class CP2108GroupInterface
extends GroupInterface {
    int interfaceNumber;
    GenericValueDialogButton[] modemPinButtons = new GenericValueDialogButton[]{new GenericValueDialogButton("TX", true, false), new GenericValueDialogButton("RX", true, false), new GenericValueDialogButton("RTS", true, false), new GenericValueDialogButton("CTS", true, false), new GenericValueDialogButton("DTR", true, false), new GenericValueDialogButton("DSR", true, false), new GenericValueDialogButton("DCD", true, false), new GenericValueDialogButton("RI", true, false)};

    public CP2108GroupInterface(Device device, int interfaceNumber) {
        super(device, interfaceNumber);
        int i = 0;
        while (i < this.modemPinButtons.length) {
            this.modemPinButtons[i].setName(String.format("%s%d", this.modemPinButtons[i].getName(), interfaceNumber));
            ++i;
        }
        Property[] propertyArray = new Property[14];
        this.pResetMode = new PropertyGenericEdit(device, "Reset Mode", GenericCellEditor.getFactory(String.format("Reset Mode", interfaceNumber), "Uncheck: Open-Drain on reset. Check: Push-Pull on reset.", this.modemPinButtons, 2));
        propertyArray[0] = this.pResetMode;
        this.pResetLowPower = new PropertyGenericEdit(device, "Reset Low Power", GenericCellEditor.getFactory(String.format("Reset Low Power", interfaceNumber), "Uncheck: Normal mode on reset. Check: Low power mode on reset.", this.modemPinButtons, 2));
        propertyArray[1] = this.pResetLowPower;
        this.pResetValue = new PropertyGenericEdit(device, "Reset Latch Value", GenericCellEditor.getFactory(String.format("Reset Latch Value", interfaceNumber), "Uncheck: Latch = 0 on reset. Check: Latch = 1 on reset.", this.modemPinButtons, 2));
        propertyArray[2] = this.pResetValue;
        this.pSuspendMode = new PropertyGenericEdit(device, "Suspend Mode", GenericCellEditor.getFactory(String.format("Suspend Mode", interfaceNumber), "Uncheck: Open-Drain in suspend. Check: Push-Pull in suspend.", this.modemPinButtons, 2));
        propertyArray[3] = this.pSuspendMode;
        this.pSuspendLowPower = new PropertyGenericEdit(device, "Suspend Low Power", GenericCellEditor.getFactory(String.format("Suspend Low Power", interfaceNumber), "Uncheck: Normal mode in suspend. Check: Low power mode in suspend.", this.modemPinButtons, 2));
        propertyArray[4] = this.pSuspendLowPower;
        this.pSuspendValue = new PropertyGenericEdit(device, "Suspend Latch Value", GenericCellEditor.getFactory(String.format("Suspend Latch Value", interfaceNumber), "Uncheck: Latch = 0 in suspend. Check: Latch = 1 in suspend.", this.modemPinButtons, 2));
        propertyArray[5] = this.pSuspendValue;
        this.pIPDelay = new PropertyIPDelay(device);
        propertyArray[6] = this.pIPDelay;
        this.pTXLEDAutoMode = new PropertyToggleValues(device, "TX LED Auto Mode", "disable", "enable");
        propertyArray[7] = this.pTXLEDAutoMode;
        this.pRXLEDAutoMode = new PropertyToggleValues(device, "RX LED Auto Mode", "disable", "enable");
        propertyArray[8] = this.pRXLEDAutoMode;
        this.pRS485AutoMode = new PropertyToggleValues(device, "RS485 Auto Mode", "disable", "enable");
        propertyArray[9] = this.pRS485AutoMode;
        this.pRS485Invert = new PropertyToggleValues(device, "RS485 Invert", "disable", "enable");
        propertyArray[10] = this.pRS485Invert;
        this.pGPIOClockEnable = new PropertyToggleValues(device, "GPIO Clock", "disable", "enable");
        propertyArray[11] = this.pGPIOClockEnable;
        this.pUseDynamicSuspend = new PropertyToggleValues(device, "Dynamic Suspend", "no", "use suspend value");
        propertyArray[12] = this.pUseDynamicSuspend;
        this.pClockDivider = new PropertyClockDivider(device);
        propertyArray[13] = this.pClockDivider;
        this.children = propertyArray;
    }
}

