/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.customizer.devices.cp210x;

public final class CP2108PinConfig {
    int[] resetMode = new int[5];
    int[] resetLowPower = new int[5];
    int[] resetValue = new int[5];
    int[] suspendMode = new int[5];
    int[] suspendLowPower = new int[5];
    int[] suspendValue = new int[5];
    int[] ipDelay = new int[4];
    int[] txLEDAutoMode = new int[4];
    int[] rxLEDAutoMode = new int[4];
    int[] rs485AutoMode = new int[4];
    int[] rs485Invert = new int[4];
    int[] useClock = new int[4];
    int[] useSuspendValues = new int[4];
    int enableWeakPullUpReset;
    int enableWeakPullUpSuspend;
    int enableDynamicSuspend;
    int[] extClk = new int[4];

    CP2108PinConfig(int[] resetMode, int[] resetLowPower, int[] resetValue, int[] suspendMode, int[] suspendLowPower, int[] suspendValue, int[] ipDelay, int[] enableGPIO0AutoMode, int[] enableGPIO1AutoMode, int[] enableGPIO2AutoMode, int[] rs485Invert, int[] useClock, int[] useSuspendValues, int eableWeakPullUpReset, int enableWeakPullUpSuspend, int enableDynamicSuspend, int[] extClk) {
        this.resetMode = resetMode;
        this.resetLowPower = resetLowPower;
        this.resetValue = resetValue;
        this.suspendMode = suspendMode;
        this.suspendLowPower = suspendLowPower;
        this.suspendValue = suspendValue;
        this.ipDelay = ipDelay;
        this.txLEDAutoMode = enableGPIO0AutoMode;
        this.rxLEDAutoMode = enableGPIO1AutoMode;
        this.rs485AutoMode = enableGPIO2AutoMode;
        this.rs485Invert = rs485Invert;
        this.useClock = useClock;
        this.useSuspendValues = useSuspendValues;
        this.enableWeakPullUpReset = eableWeakPullUpReset;
        this.enableWeakPullUpSuspend = enableWeakPullUpSuspend;
        this.enableDynamicSuspend = enableDynamicSuspend;
        this.extClk = extClk;
    }

    public CP2108PinConfig(byte[] portConfigStruct) {
        if (portConfigStruct.length < 73) {
            throw new IllegalArgumentException("portConfig.length != PORT_CONFIG_SIZE");
        }
        int i = 0;
        int portConfigOffset = 0;
        int[][] tempMaskArray = new int[6][5];
        i = 0;
        while (i < 6) {
            tempMaskArray[i][0] = portConfigStruct[portConfigOffset + 0] & 1;
            int[] nArray = tempMaskArray[i];
            nArray[0] = nArray[0] | portConfigStruct[portConfigOffset + 0] & 2;
            int[] nArray2 = tempMaskArray[i];
            nArray2[0] = nArray2[0] | portConfigStruct[portConfigOffset + 0] & 4;
            int[] nArray3 = tempMaskArray[i];
            nArray3[0] = nArray3[0] | portConfigStruct[portConfigOffset + 0] & 8;
            int[] nArray4 = tempMaskArray[i];
            nArray4[0] = nArray4[0] | portConfigStruct[portConfigOffset + 0] & 0x10;
            int[] nArray5 = tempMaskArray[i];
            nArray5[0] = nArray5[0] | portConfigStruct[portConfigOffset + 0] & 0x20;
            int[] nArray6 = tempMaskArray[i];
            nArray6[0] = nArray6[0] | portConfigStruct[portConfigOffset + 0] & 0x40;
            int[] nArray7 = tempMaskArray[i];
            nArray7[0] = nArray7[0] | portConfigStruct[portConfigOffset + 0] & 0x80;
            tempMaskArray[i][1] = portConfigStruct[portConfigOffset + 1] & 1;
            int[] nArray8 = tempMaskArray[i];
            nArray8[1] = nArray8[1] | portConfigStruct[portConfigOffset + 1] & 2;
            int[] nArray9 = tempMaskArray[i];
            nArray9[1] = nArray9[1] | portConfigStruct[portConfigOffset + 1] & 4;
            int[] nArray10 = tempMaskArray[i];
            nArray10[1] = nArray10[1] | portConfigStruct[portConfigOffset + 1] & 8;
            int[] nArray11 = tempMaskArray[i];
            nArray11[1] = nArray11[1] | portConfigStruct[portConfigOffset + 1] & 0x10;
            int[] nArray12 = tempMaskArray[i];
            nArray12[1] = nArray12[1] | portConfigStruct[portConfigOffset + 1] & 0x20;
            int[] nArray13 = tempMaskArray[i];
            nArray13[1] = nArray13[1] | portConfigStruct[portConfigOffset + 1] & 0x40;
            int[] nArray14 = tempMaskArray[i];
            nArray14[1] = nArray14[1] | portConfigStruct[portConfigOffset + 1] & 0x80;
            tempMaskArray[i][2] = portConfigStruct[portConfigOffset + 6] & 1;
            int[] nArray15 = tempMaskArray[i];
            nArray15[2] = nArray15[2] | portConfigStruct[portConfigOffset + 6] & 2;
            int[] nArray16 = tempMaskArray[i];
            nArray16[2] = nArray16[2] | portConfigStruct[portConfigOffset + 6] & 4;
            int[] nArray17 = tempMaskArray[i];
            nArray17[2] = nArray17[2] | portConfigStruct[portConfigOffset + 6] & 8;
            int[] nArray18 = tempMaskArray[i];
            nArray18[2] = nArray18[2] | (portConfigStruct[portConfigOffset + 4] & 4) << 2;
            int[] nArray19 = tempMaskArray[i];
            nArray19[2] = nArray19[2] | (portConfigStruct[portConfigOffset + 4] & 8) << 2;
            int[] nArray20 = tempMaskArray[i];
            nArray20[2] = nArray20[2] | (portConfigStruct[portConfigOffset + 6] & 0x10) << 2;
            int[] nArray21 = tempMaskArray[i];
            nArray21[2] = nArray21[2] | (portConfigStruct[portConfigOffset + 6] & 0x20) << 2;
            tempMaskArray[i][3] = (portConfigStruct[portConfigOffset + 8] & 4) >> 2;
            int[] nArray22 = tempMaskArray[i];
            nArray22[3] = nArray22[3] | (portConfigStruct[portConfigOffset + 8] & 8) >> 2;
            int[] nArray23 = tempMaskArray[i];
            nArray23[3] = nArray23[3] | (portConfigStruct[portConfigOffset + 8] & 1) << 2;
            int[] nArray24 = tempMaskArray[i];
            nArray24[3] = nArray24[3] | (portConfigStruct[portConfigOffset + 8] & 2) << 2;
            int[] nArray25 = tempMaskArray[i];
            nArray25[3] = nArray25[3] | (portConfigStruct[portConfigOffset + 6] & 0x40) >> 2;
            int[] nArray26 = tempMaskArray[i];
            nArray26[3] = nArray26[3] | (portConfigStruct[portConfigOffset + 6] & 0x80) >> 2;
            int[] nArray27 = tempMaskArray[i];
            nArray27[3] = nArray27[3] | (portConfigStruct[portConfigOffset + 7] & 1) << 6;
            int[] nArray28 = tempMaskArray[i];
            nArray28[3] = nArray28[3] | (portConfigStruct[portConfigOffset + 7] & 2) << 6;
            tempMaskArray[i][4] = portConfigStruct[portConfigOffset + 2] & 1;
            int[] nArray29 = tempMaskArray[i];
            nArray29[4] = nArray29[4] | portConfigStruct[portConfigOffset + 2] & 2;
            int[] nArray30 = tempMaskArray[i];
            nArray30[4] = nArray30[4] | portConfigStruct[portConfigOffset + 2] & 4;
            int[] nArray31 = tempMaskArray[i];
            nArray31[4] = nArray31[4] | portConfigStruct[portConfigOffset + 2] & 8;
            int[] nArray32 = tempMaskArray[i];
            nArray32[4] = nArray32[4] | portConfigStruct[portConfigOffset + 2] & 0x10;
            int[] nArray33 = tempMaskArray[i];
            nArray33[4] = nArray33[4] | portConfigStruct[portConfigOffset + 2] & 0x20;
            int[] nArray34 = tempMaskArray[i];
            nArray34[4] = nArray34[4] | portConfigStruct[portConfigOffset + 2] & 0x40;
            int[] nArray35 = tempMaskArray[i];
            nArray35[4] = nArray35[4] | portConfigStruct[portConfigOffset + 2] & 0x80;
            int[] nArray36 = tempMaskArray[i];
            nArray36[4] = nArray36[4] | (portConfigStruct[portConfigOffset + 3] & 1) << 8;
            int[] nArray37 = tempMaskArray[i];
            nArray37[4] = nArray37[4] | (portConfigStruct[portConfigOffset + 3] & 2) << 8;
            int[] nArray38 = tempMaskArray[i];
            nArray38[4] = nArray38[4] | (portConfigStruct[portConfigOffset + 3] & 4) << 8;
            int[] nArray39 = tempMaskArray[i];
            nArray39[4] = nArray39[4] | (portConfigStruct[portConfigOffset + 3] & 8) << 8;
            int[] nArray40 = tempMaskArray[i];
            nArray40[4] = nArray40[4] | (portConfigStruct[portConfigOffset + 3] & 0x10) << 8;
            int[] nArray41 = tempMaskArray[i];
            nArray41[4] = nArray41[4] | (portConfigStruct[portConfigOffset + 3] & 0x20) << 8;
            int[] nArray42 = tempMaskArray[i];
            nArray42[4] = nArray42[4] | (portConfigStruct[portConfigOffset + 3] & 0x40) << 8;
            int[] nArray43 = tempMaskArray[i];
            nArray43[4] = nArray43[4] | (portConfigStruct[portConfigOffset + 3] & 0x80) << 8;
            portConfigOffset += 10;
            ++i;
        }
        System.arraycopy(tempMaskArray[0], 0, this.resetMode, 0, 5);
        System.arraycopy(tempMaskArray[1], 0, this.resetLowPower, 0, 5);
        System.arraycopy(tempMaskArray[2], 0, this.resetValue, 0, 5);
        System.arraycopy(tempMaskArray[3], 0, this.suspendMode, 0, 5);
        System.arraycopy(tempMaskArray[4], 0, this.suspendLowPower, 0, 5);
        System.arraycopy(tempMaskArray[5], 0, this.suspendValue, 0, 5);
        this.ipDelay[0] = portConfigStruct[portConfigOffset++] & 0xFF;
        this.ipDelay[1] = portConfigStruct[portConfigOffset++] & 0xFF;
        this.ipDelay[2] = portConfigStruct[portConfigOffset++] & 0xFF;
        this.ipDelay[3] = portConfigStruct[portConfigOffset++] & 0xFF;
        i = 0;
        while (i < 4) {
            this.txLEDAutoMode[i] = (portConfigStruct[portConfigOffset] & 1) != 0 ? 1 : 0;
            this.rxLEDAutoMode[i] = (portConfigStruct[portConfigOffset] & 2) != 0 ? 1 : 0;
            this.rs485AutoMode[i] = (portConfigStruct[portConfigOffset] & 4) != 0 ? 1 : 0;
            this.rs485Invert[i] = (portConfigStruct[portConfigOffset] & 8) != 0 ? 1 : 0;
            this.useClock[i] = (portConfigStruct[portConfigOffset] & 0x10) != 0 ? 1 : 0;
            this.useSuspendValues[i] = (portConfigStruct[portConfigOffset] & 0x40) != 0 ? 1 : 0;
            ++portConfigOffset;
            ++i;
        }
        this.enableWeakPullUpReset = (portConfigStruct[portConfigOffset] & 0x10) != 0 ? 1 : 0;
        this.enableWeakPullUpSuspend = (portConfigStruct[portConfigOffset] & 0x20) != 0 ? 1 : 0;
        this.enableDynamicSuspend = (portConfigStruct[portConfigOffset] & 0x40) != 0 ? 1 : 0;
        int n = ++portConfigOffset;
        this.extClk[0] = portConfigStruct[n] & 0xFF;
        int n2 = ++portConfigOffset;
        this.extClk[1] = portConfigStruct[n2] & 0xFF;
        int n3 = ++portConfigOffset;
        this.extClk[2] = portConfigStruct[n3] & 0xFF;
        int n4 = ++portConfigOffset;
        ++portConfigOffset;
        this.extClk[3] = portConfigStruct[n4] & 0xFF;
    }

    public String toString() {
        String s = "PinConfig [\n";
        int i = 0;
        while (i < 4) {
            s = String.valueOf(s) + String.format("[Interface %d: resetMode=%X, resetLowPower=%X, resetValue=%X, suspendMode=%X, suspendLowPower=%X, suspendValue=%X, ipDelay=%X, txLEDAutoMode=%X, rxLEDAutoMode=%X, rs485AutoMode=%X, rs485Invert=%X, useClock=%X, useSuspendValues=%X, extClk=%X]\n", i, this.resetMode[i], this.resetLowPower[i], this.resetValue[i], this.suspendMode[i], this.suspendLowPower[i], this.suspendValue[i], this.ipDelay[i], this.txLEDAutoMode[i], this.rxLEDAutoMode[i], this.rs485AutoMode[i], this.rs485Invert[i], this.useClock[i], this.useSuspendValues[i], this.extClk[i]);
            ++i;
        }
        s = String.valueOf(s) + String.format("[GPIO: resetMode=%X, resetLowPower=%X, resetValue=%X, suspendMode=%X, suspendLowPower=%X, suspendValue=%X]\n", this.resetMode[4], this.resetLowPower[4], this.resetValue[4], this.suspendMode[4], this.suspendLowPower[4], this.suspendValue[4]);
        s = String.valueOf(s) + String.format("enableWeakPullUpReset=%X, enableWeakPullUpSuspend=%X, enableDynamicSuspend=%X\n]", this.enableWeakPullUpReset, this.enableWeakPullUpSuspend, this.enableDynamicSuspend);
        return s;
    }

    public byte[] getConfigStruct() {
        byte[] portConfigStruct = new byte[73];
        int i = 0;
        int portConfigOffset = 0;
        int[][] tempMaskArray = new int[6][5];
        System.arraycopy(this.resetMode, 0, tempMaskArray[0], 0, 5);
        System.arraycopy(this.resetLowPower, 0, tempMaskArray[1], 0, 5);
        System.arraycopy(this.resetValue, 0, tempMaskArray[2], 0, 5);
        System.arraycopy(this.suspendMode, 0, tempMaskArray[3], 0, 5);
        System.arraycopy(this.suspendLowPower, 0, tempMaskArray[4], 0, 5);
        System.arraycopy(this.suspendValue, 0, tempMaskArray[5], 0, 5);
        i = 0;
        while (i < 6) {
            portConfigStruct[portConfigOffset + 0] = (byte)(tempMaskArray[i][0] & 1);
            int n = portConfigOffset + 0;
            portConfigStruct[n] = (byte)(portConfigStruct[n] | (byte)(tempMaskArray[i][0] & 2));
            int n2 = portConfigOffset + 0;
            portConfigStruct[n2] = (byte)(portConfigStruct[n2] | (byte)(tempMaskArray[i][0] & 4));
            int n3 = portConfigOffset + 0;
            portConfigStruct[n3] = (byte)(portConfigStruct[n3] | (byte)(tempMaskArray[i][0] & 8));
            int n4 = portConfigOffset + 0;
            portConfigStruct[n4] = (byte)(portConfigStruct[n4] | (byte)(tempMaskArray[i][0] & 0x10));
            int n5 = portConfigOffset + 0;
            portConfigStruct[n5] = (byte)(portConfigStruct[n5] | (byte)(tempMaskArray[i][0] & 0x20));
            int n6 = portConfigOffset + 0;
            portConfigStruct[n6] = (byte)(portConfigStruct[n6] | (byte)(tempMaskArray[i][0] & 0x40));
            int n7 = portConfigOffset + 0;
            portConfigStruct[n7] = (byte)(portConfigStruct[n7] | (byte)(tempMaskArray[i][0] & 0x80));
            portConfigStruct[portConfigOffset + 1] = (byte)(tempMaskArray[i][1] & 1);
            int n8 = portConfigOffset + 1;
            portConfigStruct[n8] = (byte)(portConfigStruct[n8] | (byte)(tempMaskArray[i][1] & 2));
            int n9 = portConfigOffset + 1;
            portConfigStruct[n9] = (byte)(portConfigStruct[n9] | (byte)(tempMaskArray[i][1] & 4));
            int n10 = portConfigOffset + 1;
            portConfigStruct[n10] = (byte)(portConfigStruct[n10] | (byte)(tempMaskArray[i][1] & 8));
            int n11 = portConfigOffset + 1;
            portConfigStruct[n11] = (byte)(portConfigStruct[n11] | (byte)(tempMaskArray[i][1] & 0x10));
            int n12 = portConfigOffset + 1;
            portConfigStruct[n12] = (byte)(portConfigStruct[n12] | (byte)(tempMaskArray[i][1] & 0x20));
            int n13 = portConfigOffset + 1;
            portConfigStruct[n13] = (byte)(portConfigStruct[n13] | (byte)(tempMaskArray[i][1] & 0x40));
            int n14 = portConfigOffset + 1;
            portConfigStruct[n14] = (byte)(portConfigStruct[n14] | (byte)(tempMaskArray[i][1] & 0x80));
            portConfigStruct[portConfigOffset + 2] = (byte)(tempMaskArray[i][4] & 1);
            int n15 = portConfigOffset + 2;
            portConfigStruct[n15] = (byte)(portConfigStruct[n15] | (byte)(tempMaskArray[i][4] & 2));
            int n16 = portConfigOffset + 2;
            portConfigStruct[n16] = (byte)(portConfigStruct[n16] | (byte)(tempMaskArray[i][4] & 4));
            int n17 = portConfigOffset + 2;
            portConfigStruct[n17] = (byte)(portConfigStruct[n17] | (byte)(tempMaskArray[i][4] & 8));
            int n18 = portConfigOffset + 2;
            portConfigStruct[n18] = (byte)(portConfigStruct[n18] | (byte)(tempMaskArray[i][4] & 0x10));
            int n19 = portConfigOffset + 2;
            portConfigStruct[n19] = (byte)(portConfigStruct[n19] | (byte)(tempMaskArray[i][4] & 0x20));
            int n20 = portConfigOffset + 2;
            portConfigStruct[n20] = (byte)(portConfigStruct[n20] | (byte)(tempMaskArray[i][4] & 0x40));
            int n21 = portConfigOffset + 2;
            portConfigStruct[n21] = (byte)(portConfigStruct[n21] | (byte)(tempMaskArray[i][4] & 0x80));
            portConfigStruct[portConfigOffset + 3] = (byte)((tempMaskArray[i][4] & 0x100) >> 8);
            int n22 = portConfigOffset + 3;
            portConfigStruct[n22] = (byte)(portConfigStruct[n22] | (byte)((tempMaskArray[i][4] & 0x200) >> 8));
            int n23 = portConfigOffset + 3;
            portConfigStruct[n23] = (byte)(portConfigStruct[n23] | (byte)((tempMaskArray[i][4] & 0x400) >> 8));
            int n24 = portConfigOffset + 3;
            portConfigStruct[n24] = (byte)(portConfigStruct[n24] | (byte)((tempMaskArray[i][4] & 0x800) >> 8));
            int n25 = portConfigOffset + 3;
            portConfigStruct[n25] = (byte)(portConfigStruct[n25] | (byte)((tempMaskArray[i][4] & 0x1000) >> 8));
            int n26 = portConfigOffset + 3;
            portConfigStruct[n26] = (byte)(portConfigStruct[n26] | (byte)((tempMaskArray[i][4] & 0x2000) >> 8));
            int n27 = portConfigOffset + 3;
            portConfigStruct[n27] = (byte)(portConfigStruct[n27] | (byte)((tempMaskArray[i][4] & 0x4000) >> 8));
            int n28 = portConfigOffset + 3;
            portConfigStruct[n28] = (byte)(portConfigStruct[n28] | (byte)((tempMaskArray[i][4] & 0x8000) >> 8));
            portConfigStruct[portConfigOffset + 4] = (byte)(tempMaskArray[i][2] >> 2 & 4);
            int n29 = portConfigOffset + 4;
            portConfigStruct[n29] = (byte)(portConfigStruct[n29] | (byte)(tempMaskArray[i][2] >> 2 & 8));
            portConfigStruct[portConfigOffset + 6] = (byte)(tempMaskArray[i][2] & 1);
            int n30 = portConfigOffset + 6;
            portConfigStruct[n30] = (byte)(portConfigStruct[n30] | (byte)(tempMaskArray[i][2] & 2));
            int n31 = portConfigOffset + 6;
            portConfigStruct[n31] = (byte)(portConfigStruct[n31] | (byte)(tempMaskArray[i][2] & 4));
            int n32 = portConfigOffset + 6;
            portConfigStruct[n32] = (byte)(portConfigStruct[n32] | (byte)(tempMaskArray[i][2] & 8));
            int n33 = portConfigOffset + 6;
            portConfigStruct[n33] = (byte)(portConfigStruct[n33] | (byte)(tempMaskArray[i][2] >> 2 & 0x10));
            int n34 = portConfigOffset + 6;
            portConfigStruct[n34] = (byte)(portConfigStruct[n34] | (byte)(tempMaskArray[i][2] >> 2 & 0x20));
            int n35 = portConfigOffset + 6;
            portConfigStruct[n35] = (byte)(portConfigStruct[n35] | (byte)(tempMaskArray[i][3] << 2 & 0x40));
            int n36 = portConfigOffset + 6;
            portConfigStruct[n36] = (byte)(portConfigStruct[n36] | (byte)(tempMaskArray[i][3] << 2 & 0x80));
            portConfigStruct[portConfigOffset + 7] = (byte)(tempMaskArray[i][3] >> 6 & 1);
            int n37 = portConfigOffset + 7;
            portConfigStruct[n37] = (byte)(portConfigStruct[n37] | (byte)(tempMaskArray[i][3] >> 6 & 2));
            portConfigStruct[portConfigOffset + 8] = (byte)(tempMaskArray[i][3] >> 2 & 1);
            int n38 = portConfigOffset + 8;
            portConfigStruct[n38] = (byte)(portConfigStruct[n38] | (byte)(tempMaskArray[i][3] >> 2 & 2));
            int n39 = portConfigOffset + 8;
            portConfigStruct[n39] = (byte)(portConfigStruct[n39] | (byte)(tempMaskArray[i][3] << 2 & 4));
            int n40 = portConfigOffset + 8;
            portConfigStruct[n40] = (byte)(portConfigStruct[n40] | (byte)(tempMaskArray[i][3] << 2 & 8));
            portConfigOffset += 10;
            ++i;
        }
        portConfigStruct[portConfigOffset++] = (byte)this.ipDelay[0];
        portConfigStruct[portConfigOffset++] = (byte)this.ipDelay[1];
        portConfigStruct[portConfigOffset++] = (byte)this.ipDelay[2];
        portConfigStruct[portConfigOffset++] = (byte)this.ipDelay[3];
        i = 0;
        while (i < 4) {
            if (this.txLEDAutoMode[i] != 0) {
                int n = portConfigOffset;
                portConfigStruct[n] = (byte)(portConfigStruct[n] | 1);
            }
            if (this.rxLEDAutoMode[i] != 0) {
                int n = portConfigOffset;
                portConfigStruct[n] = (byte)(portConfigStruct[n] | 2);
            }
            if (this.rs485AutoMode[i] != 0) {
                int n = portConfigOffset;
                portConfigStruct[n] = (byte)(portConfigStruct[n] | 4);
            }
            if (this.rs485Invert[i] != 0) {
                int n = portConfigOffset;
                portConfigStruct[n] = (byte)(portConfigStruct[n] | 8);
            }
            if (this.useClock[i] != 0) {
                int n = portConfigOffset;
                portConfigStruct[n] = (byte)(portConfigStruct[n] | 0x10);
            }
            if (this.useSuspendValues[i] != 0) {
                int n = portConfigOffset;
                portConfigStruct[n] = (byte)(portConfigStruct[n] | 0x40);
            }
            ++portConfigOffset;
            ++i;
        }
        if (this.enableWeakPullUpReset != 0) {
            portConfigStruct[portConfigOffset] = 16;
        }
        if (this.enableWeakPullUpSuspend != 0) {
            int n = portConfigOffset;
            portConfigStruct[n] = (byte)(portConfigStruct[n] | 0x20);
        }
        if (this.enableDynamicSuspend != 0) {
            int n = portConfigOffset;
            portConfigStruct[n] = (byte)(portConfigStruct[n] | 0x40);
        }
        int n = ++portConfigOffset;
        portConfigStruct[n] = (byte)this.extClk[0];
        int n41 = ++portConfigOffset;
        portConfigStruct[n41] = (byte)this.extClk[1];
        int n42 = ++portConfigOffset;
        portConfigStruct[n42] = (byte)this.extClk[2];
        int n43 = ++portConfigOffset;
        ++portConfigOffset;
        portConfigStruct[n43] = (byte)this.extClk[3];
        return portConfigStruct;
    }
}

