/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.customizer.devices.cp210x;

import com.silabs.customizer.devices.PropertyBaudConfig;
import java.util.Arrays;

public final class CP210xBaudConfig {
    static final int expectedBaudConfigSize = 384;
    static final int expectedBaudConfigNum = 32;
    final BaudConfig[] baudConfigs;

    CP210xBaudConfig(byte[] baudConfigStruct) {
        if (baudConfigStruct.length != 384) {
            throw new IllegalArgumentException("baudConfigs.length != expectedBaudConfigCount");
        }
        this.baudConfigs = new BaudConfig[32];
        int structIndex = 0;
        int i = 0;
        while (i < 32) {
            this.baudConfigs[i] = new BaudConfig();
            this.baudConfigs[i].baudGen = baudConfigStruct[structIndex++] & 0xFF;
            this.baudConfigs[i].baudGen |= (baudConfigStruct[structIndex++] & 0xFF) << 8;
            this.baudConfigs[i].timer0Reload = baudConfigStruct[structIndex++] & 0xFF;
            this.baudConfigs[i].timer0Reload |= (baudConfigStruct[structIndex++] & 0xFF) << 8;
            this.baudConfigs[i].prescaler = baudConfigStruct[structIndex++];
            ++structIndex;
            ++structIndex;
            int n = ++structIndex;
            this.baudConfigs[i].baudRate = baudConfigStruct[n] & 0xFF;
            int n2 = ++structIndex;
            this.baudConfigs[i].baudRate |= (long)((baudConfigStruct[n2] & 0xFF) << 8);
            int n3 = ++structIndex;
            this.baudConfigs[i].baudRate |= (long)((baudConfigStruct[n3] & 0xFF) << 16);
            int n4 = ++structIndex;
            ++structIndex;
            this.baudConfigs[i].baudRate |= (long)((baudConfigStruct[n4] & 0xFF) << 24);
            this.baudConfigs[i].baudGen &= 0xFFFF;
            this.baudConfigs[i].timer0Reload &= 0xFFFF;
            this.baudConfigs[i].prescaler = (short)(this.baudConfigs[i].prescaler & 0xFF);
            this.baudConfigs[i].baudRate &= 0xFFFFFFFFFFFFFFFFL;
            ++i;
        }
    }

    CP210xBaudConfig(PropertyBaudConfig[] pBaudConfigs) {
        if (pBaudConfigs.length != 32) {
            throw new IllegalArgumentException("pBaudConfigs.length != expectedBaudConfigNum");
        }
        this.baudConfigs = new BaudConfig[32];
        int i = 0;
        while (i < 32) {
            this.baudConfigs[i] = new BaudConfig();
            this.baudConfigs[i].baudGen = pBaudConfigs[i].getBaudGen();
            this.baudConfigs[i].timer0Reload = pBaudConfigs[i].getTimer0Reload();
            this.baudConfigs[i].prescaler = pBaudConfigs[i].getPrescaler();
            this.baudConfigs[i].baudRate = pBaudConfigs[i].getBaudRate();
            ++i;
        }
    }

    public String toString() {
        return String.format("BaudConfig [Baudrate (BaudGen, Prescaler, Timer0Reload)]\n%s", Arrays.toString(this.baudConfigs));
    }

    public byte[] getConfigStruct() {
        byte[] baudConfigStruct = new byte[384];
        int structIndex = 0;
        int i = 0;
        while (i < 32) {
            baudConfigStruct[structIndex++] = (byte)(this.baudConfigs[i].baudGen & 0xFF);
            baudConfigStruct[structIndex++] = (byte)((this.baudConfigs[i].baudGen & 0xFF00) >> 8);
            baudConfigStruct[structIndex++] = (byte)(this.baudConfigs[i].timer0Reload & 0xFF);
            baudConfigStruct[structIndex++] = (byte)((this.baudConfigs[i].timer0Reload & 0xFF00) >> 8);
            baudConfigStruct[structIndex++] = (byte)(this.baudConfigs[i].prescaler & 0xFF);
            ++structIndex;
            ++structIndex;
            int n = ++structIndex;
            baudConfigStruct[n] = (byte)(this.baudConfigs[i].baudRate & 0xFFL);
            int n2 = ++structIndex;
            baudConfigStruct[n2] = (byte)((this.baudConfigs[i].baudRate & 0xFF00L) >> 8);
            int n3 = ++structIndex;
            baudConfigStruct[n3] = (byte)((this.baudConfigs[i].baudRate & 0xFF0000L) >> 16);
            int n4 = ++structIndex;
            ++structIndex;
            baudConfigStruct[n4] = (byte)((this.baudConfigs[i].baudRate & 0xFFFFFFFFFF000000L) >> 24);
            ++i;
        }
        return baudConfigStruct;
    }

    public static final class BaudConfig {
        int baudGen;
        int timer0Reload;
        short prescaler;
        long baudRate;

        public String toString() {
            return String.format("[%d (%04X, %02X, %04X)]\n", this.baudRate, this.baudGen, this.prescaler, this.timer0Reload);
        }
    }
}

