/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.customizer.devices.cp211x;

import com.silabs.customizer.Application;
import com.silabs.customizer.devices.Device;
import com.silabs.customizer.devices.GroupPortConfigRoot;
import com.silabs.customizer.devices.Property;
import com.silabs.customizer.devices.PropertyClockDivider;
import com.silabs.customizer.devices.PropertyRS485PinLevel;
import com.silabs.customizer.devices.PropertySuspendMode;
import com.silabs.customizer.devices.PropertySuspendValue;
import com.silabs.customizer.devices.PropertyToggleValues;
import com.silabs.customizer.devices.cp211x.CP2110GroupPins;
import com.silabs.customizer.devices.cp211x.CP2110PinConfig;
import com.silabs.customizer.devices.cp211x.CP2110SuspendModeCellEditor;
import com.silabs.customizer.devices.cp211x.CP2110SuspendValueCellEditor;
import com.silabs.customizer.devices.cp211x.Device2110;
import com.silabs.customizer.log.MessageLog;

class CP2110GroupPortConfigRoot
extends GroupPortConfigRoot {
    public CP2110GroupPortConfigRoot(Device device) {
        super(device, "CP2110PortConfigGroup");
        Property[] propertyArray = new Property[6];
        this.grpPins = new CP2110GroupPins(device);
        propertyArray[0] = this.grpPins;
        this.pUseSuspend = new PropertyToggleValues(device, "Use Suspend Values", "no", "use suspend value/mode");
        propertyArray[1] = this.pUseSuspend;
        this.pSuspendValue = new PropertySuspendValue(device, CP2110SuspendValueCellEditor.getFactory());
        propertyArray[2] = this.pSuspendValue;
        this.pSuspendMode = new PropertySuspendMode(device, CP2110SuspendModeCellEditor.getFactory());
        propertyArray[3] = this.pSuspendMode;
        this.p485Level = new PropertyRS485PinLevel(device);
        propertyArray[4] = this.p485Level;
        this.pClockDivider = new PropertyClockDivider(device);
        propertyArray[5] = this.pClockDivider;
        this.children = propertyArray;
        this.pinCount = 13;
        this.initProperty();
    }

    @Override
    public void program() {
        if (!this.isChanged() || this.isError()) {
            return;
        }
        CP2110PinConfig writeConfig = null;
        try {
            writeConfig = this.createPinConfig();
            if (Application.DRY_RUN) {
                this.updateDefaults(writeConfig);
            } else {
                Device2110.setPinConfig(this.getDevice(), writeConfig);
                CP2110PinConfig newDefaults = this.readPinConfig();
                this.updateDefaults(newDefaults);
            }
            this.updateWritten(true);
            this.updateError();
            this.logWrite(this.isError(), null, writeConfig);
        }
        catch (Exception exc) {
            this.logWrite(true, exc, writeConfig);
        }
    }

    @Override
    protected String readValueFromDevice() throws Exception {
        if (this.children != null) {
            CP2110PinConfig config = this.readPinConfig();
            this.updateDefaults(config);
            this.updateValues(config);
        }
        return "";
    }

    private CP2110PinConfig createPinConfig() {
        Property[] pPins = this.grpPins.getChildren();
        if (pPins.length != this.pinCount) {
            throw new IllegalStateException("Error in number of configurable pins!");
        }
        byte[] pinConfigs = new byte[pPins.length];
        int i = 0;
        while (i < pinConfigs.length) {
            pinConfigs[i] = Byte.parseByte(pPins[i].getValue(), 16);
            ++i;
        }
        int useSuspend = Integer.parseInt(this.pUseSuspend.getValue(), 16);
        int suspendValue = Integer.parseInt(this.pSuspendValue.getValue(), 16);
        int suspendMode = Integer.parseInt(this.pSuspendMode.getValue(), 16);
        byte rs485level = Byte.parseByte(this.p485Level.getValue(), 16);
        short clkDiv = Short.parseShort(this.pClockDivider.getValue(), 16);
        return new CP2110PinConfig(pinConfigs, useSuspend, suspendValue, suspendMode, rs485level, clkDiv);
    }

    private final void logWrite(boolean error, Exception exc, CP2110PinConfig config) {
        if (!error) {
            MessageLog.info(String.format("%s Successul write of %s: %s", this.getDevice().getType(), this.getName(), config));
        } else {
            String message = String.format("%s FAILED write of %s: %s", this.getDevice().getType(), this.getName(), config);
            MessageLog.error(message, exc);
        }
    }

    private CP2110PinConfig readPinConfig() throws Exception {
        return Device2110.getPinConfig(this.getDevice());
    }

    private void updateDefaults(CP2110PinConfig config) {
        Property[] pPins = this.grpPins.getChildren();
        if (pPins.length != this.pinCount) {
            throw new IllegalStateException("Error in number of configurable pins!");
        }
        int i = 0;
        while (i < pPins.length) {
            String pinValue = String.format("%02X", config.pinConfigs[i]);
            pPins[i].setDefaultValue(pinValue);
            ++i;
        }
        this.pUseSuspend.setDefaultValue(String.valueOf(config.useSuspendValues));
        this.pSuspendValue.setDefaultValue(String.format("%04X", config.suspendValue));
        this.pSuspendMode.setDefaultValue(String.format("%04X", config.suspendMode));
        this.p485Level.setDefaultValue(String.format("%02X", config.rs485level));
        this.pClockDivider.setDefaultValue(String.format("%02X", config.clkDiv));
    }

    private void updateError() {
        Property[] props;
        Property[] propertyArray = this.grpPins.getChildren();
        int n = propertyArray.length;
        int n2 = 0;
        while (n2 < n) {
            Property prop = propertyArray[n2];
            boolean error = !prop.getDefaultValue().equals(prop.getValue());
            prop.setError(error);
            ++n2;
        }
        Property[] propertyArray2 = props = new Property[]{this.pUseSuspend, this.pSuspendValue, this.pSuspendMode, this.p485Level, this.pClockDivider};
        int n3 = props.length;
        n = 0;
        while (n < n3) {
            Property prop = propertyArray2[n];
            boolean error = !prop.getDefaultValue().equals(prop.getValue());
            prop.setError(error);
            ++n;
        }
    }

    private void updateValues(CP2110PinConfig config) {
        Property[] pPins = this.grpPins.getChildren();
        if (pPins.length != this.pinCount) {
            throw new IllegalStateException("Error in number of configurable pins!");
        }
        int i = 0;
        while (i < this.pinCount) {
            String pinValue = String.format("%02X", config.pinConfigs[i]);
            pPins[i].setValue(pinValue);
            ++i;
        }
        this.pUseSuspend.setValue(String.valueOf(config.useSuspendValues));
        this.pSuspendValue.setValue(String.format("%04X", config.suspendValue));
        this.pSuspendMode.setValue(String.format("%04X", config.suspendMode));
        this.p485Level.setValue(String.format("%02X", config.rs485level));
        this.pClockDivider.setValue(String.format("%02X", config.clkDiv));
    }

    private void updateWritten(boolean written) {
        Property[] propertyArray = this.grpPins.getChildren();
        int n = propertyArray.length;
        int n2 = 0;
        while (n2 < n) {
            Property prop = propertyArray[n2];
            prop.setWritten(written);
            ++n2;
        }
        this.pUseSuspend.setWritten(written);
        this.pSuspendValue.setWritten(written);
        this.pSuspendMode.setWritten(written);
        this.p485Level.setWritten(written);
        this.pClockDivider.setWritten(written);
    }

    @Override
    public void resetSiliconLabsDefaultValues() {
        Property[] pPins = this.grpPins.getChildren();
        if (pPins.length != this.pinCount) {
            throw new IllegalStateException("Error in number of configurable pins!");
        }
        pPins[0].reset("00");
        pPins[1].reset("03");
        pPins[2].reset("03");
        pPins[3].reset("03");
        pPins[4].reset("03");
        pPins[5].reset("03");
        pPins[6].reset("00");
        pPins[7].reset("00");
        pPins[8].reset("02");
        pPins[9].reset("02");
        pPins[10].reset("02");
        pPins[11].reset("02");
        pPins[12].reset("02");
        this.pUseSuspend.reset("0");
        this.pSuspendValue.reset("0000");
        this.pSuspendMode.reset("0000");
        this.p485Level.reset("01");
        this.pClockDivider.reset("00");
    }
}

