/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.customizer.devices.cp211x;

import com.silabs.customizer.devices.Device;
import com.silabs.customizer.devices.DeviceDetector;
import com.silabs.customizer.devices.Property;
import com.silabs.customizer.devices.PropertyFlushBuffers;
import com.silabs.customizer.devices.PropertyLockValue;
import com.silabs.customizer.devices.PropertyManufacturer;
import com.silabs.customizer.devices.PropertyPID;
import com.silabs.customizer.devices.PropertyPower;
import com.silabs.customizer.devices.PropertyPowerModeWithVReg;
import com.silabs.customizer.devices.PropertyProductDescr;
import com.silabs.customizer.devices.PropertyReleaseVer;
import com.silabs.customizer.devices.PropertySerial;
import com.silabs.customizer.devices.PropertyVID;
import com.silabs.customizer.devices.cp211x.CP2110GroupPortConfigRoot;
import com.silabs.customizer.devices.cp211x.CP2110PinConfig;
import com.silabs.customizer.devices.cp211x.Device211x;
import com.silabs.customizer.devices.cp211x.SLABHIDtoUART;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.ByteByReference;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.ShortByReference;

final class Device2110
extends Device211x {
    Device2110(String serial) {
        super(serial);
        this.setOTP(true);
        this.setShowConfigureIds(true);
        this.setShowConfigureBaudRate(false);
        this.setShowConfigurePins(true);
    }

    @Override
    public String getType() {
        return "CP2110";
    }

    @Override
    protected synchronized Property[] createIds() {
        DeviceDetector.getDefault().stop();
        Property[] result = new Property[]{new PropertyVID(this), new PropertyPID(this), new PropertyPower(this), new PropertyPowerModeWithVReg(this), new PropertyReleaseVer(this), new PropertyFlushBuffers(this, 1), new PropertyManufacturer(this), new PropertyProductDescr(this), new PropertySerial(this, 30), new PropertyLockValue(this)};
        DeviceDetector.getDefault().start();
        return result;
    }

    public static synchronized void setPinConfig(Device deviceObj, CP2110PinConfig writeConfig) throws Exception {
        Device2110.checkDeviceDetection();
        if (writeConfig.pinConfigs.length != 13) {
            throw new IllegalStateException("Error in number of configurable pins!");
        }
        Pointer device = Device2110.openDevice((Device211x)deviceObj);
        int status = SLABHIDtoUART.DLL.HidUart_SetPinConfig(device, writeConfig.pinConfigs, writeConfig.useSupendValues(), writeConfig.suspendValue, writeConfig.suspendMode, writeConfig.rs485level, writeConfig.clkDiv);
        Device2110.close(device);
        LOG.logDebug(status, "setPinConfig", writeConfig);
        if (status != 0) {
            throw new Exception("setPinconfig(" + deviceObj + "): " + status);
        }
    }

    protected static synchronized CP2110PinConfig getPinConfig(Device deviceObj) throws Exception {
        Device2110.checkDeviceDetection();
        Pointer device = Device2110.openDevice((Device211x)deviceObj);
        byte[] pinConfig = new byte[13];
        IntByReference useSuspendValues = new IntByReference();
        IntByReference suspendValue = new IntByReference();
        IntByReference suspendMode = new IntByReference();
        ByteByReference rs485level = new ByteByReference();
        ShortByReference clkDiv = new ShortByReference();
        int status = SLABHIDtoUART.DLL.HidUart_GetPinConfig(device, pinConfig, useSuspendValues, suspendValue, suspendMode, rs485level, clkDiv);
        Device2110.close(device);
        CP2110PinConfig result = new CP2110PinConfig(pinConfig, useSuspendValues.getValue(), suspendValue.getValue(), suspendMode.getValue(), rs485level.getValue(), clkDiv.getValue());
        LOG.logDebug(status, "getPinConfig", result);
        if (status != 0) {
            throw new Exception("getPinConfig(" + deviceObj + "): " + status);
        }
        return result;
    }

    @Override
    protected synchronized Property[] createPortConfigs() {
        DeviceDetector.getDefault().stop();
        Property[] result = new Property[]{new CP2110GroupPortConfigRoot(this)};
        DeviceDetector.getDefault().start();
        return result;
    }

    @Override
    public String getLockValue(Device deviceObj) throws Exception {
        Device2110.checkDeviceDetection();
        Pointer device = Device2110.openDevice((Device211x)deviceObj);
        ShortByReference lockValue = new ShortByReference();
        int status = SLABHIDtoUART.DLL.HidUart_GetLock(device, lockValue);
        Device2110.close(device);
        String result = "00";
        if (lockValue.getValue() == 0) {
            result = "01";
        }
        LOG.logDebug(status, "getLockValue:", result);
        if (status != 0) {
            throw new Exception("getLockValue(" + deviceObj + "): " + status);
        }
        return result;
    }

    @Override
    public void setLockValue(Device deviceObj, String value) throws Exception {
        Device2110.checkDeviceDetection();
        Pointer device = Device2110.openDevice((Device211x)deviceObj);
        short lockValue = 0;
        int status = SLABHIDtoUART.DLL.HidUart_SetLock(device, lockValue);
        Device2110.close(device);
        LOG.logDebug(status, "setLockValue:", value);
        if (status != 0) {
            throw new Exception("setLockValue(" + deviceObj + "): " + status);
        }
    }

    @Override
    public final void resetSiliconLabsDefaultValues() {
        Property[] idProps = this.getIds();
        idProps[0].reset("10C4");
        idProps[1].reset("EA80");
        idProps[2].reset("32");
        idProps[3].reset("00");
        idProps[4].reset("0100");
        idProps[5].reset("05");
        idProps[6].reset("Silicon Laboratories");
        idProps[7].reset("CP2110 HID USB-to-UART Bridge");
        idProps[9].reset("00");
        Property[] portConfigProps = this.getPortConfigs();
        CP2110GroupPortConfigRoot cp2110PortConfigRoot = (CP2110GroupPortConfigRoot)portConfigProps[0];
        cp2110PortConfigRoot.resetSiliconLabsDefaultValues();
    }
}

