/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.customizer.devices.cp261x;

import com.silabs.customizer.devices.Device;
import com.silabs.customizer.devices.Item;
import com.silabs.customizer.devices.Property;
import java.util.Locale;

public class PropertyNowPlayingEnable
extends Property {
    public PropertyNowPlayingEnable(Device device) {
        super(device, null, "Enable \"Now Playing\"", new Item[]{new Item("0", String.format("No", new Object[0])), new Item("1", String.format("Yes", new Object[0]))});
        this.initBitMask(1, "CFG_FLAG_ENABLE_NOW_PLAYING");
        this.initProperty();
    }

    @Override
    public void setDefaultValue(String value) {
        super.setDefaultValue(value.toUpperCase(Locale.ENGLISH));
    }

    @Override
    public void setValue(String value) {
        try {
            super.setValue(value);
        }
        catch (NumberFormatException numberFormatException) {}
    }

    @Override
    protected String readValueFromDevice() throws Exception {
        return "1";
    }

    public String getMessagesSentXML() {
        if (this.getValue() != "0") {
            String xmlValueString = "      <field name=\"msgStartNowPlayingUpdates\" type=\"hex\" size=\"2\" order=\"be\">\n";
            xmlValueString = String.valueOf(xmlValueString) + "        <value>0x5000</value>\n";
            xmlValueString = String.valueOf(xmlValueString) + "      </field>\n";
            xmlValueString = String.valueOf(xmlValueString) + "      <field name=\"msgStopNowPlayingUpdates\" type=\"hex\" size=\"2\" order=\"be\">\n";
            xmlValueString = String.valueOf(xmlValueString) + "        <value>0x5002</value>\n";
            xmlValueString = String.valueOf(xmlValueString) + "      </field>";
            return xmlValueString;
        }
        String xmlValueString = "";
        return xmlValueString;
    }

    public String getMessagesReceivedXML() {
        String xmlValueString;
        if (this.getValue() == "0") {
            xmlValueString = "";
        } else {
            xmlValueString = "      <field name=\"msgNowPlayingUpdate\" type=\"hex\" size=\"2\" order=\"be\">\n";
            xmlValueString = String.valueOf(xmlValueString) + "        <value>0x5001</value>\n";
            xmlValueString = String.valueOf(xmlValueString) + "      </field>";
        }
        return xmlValueString;
    }
}

