/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.customizer.log;

import com.silabs.customizer.log.AbstractAppender;
import java.text.DateFormat;
import java.util.Date;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.TextStyle;
import org.osgi.service.log.LogEntry;

public final class TextAppender
extends AbstractAppender
implements DisposeListener {
    private static final int MAX_LOG_LENGTH = 100000;
    private final StyledText text;
    private final TextStyle styleError;

    public TextAppender(StyledText text) {
        this.text = text;
        Color colorRed = text.getDisplay().getSystemColor(3);
        this.styleError = new TextStyle(null, colorRed, null);
        text.addDisposeListener((DisposeListener)this);
        this.start();
    }

    @Override
    public void logged(final LogEntry entry) {
        if (this.text != null && !this.text.isDisposed()) {
            final String message = this.getMessage(entry);
            this.text.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!TextAppender.this.text.isDisposed()) {
                        int start = TextAppender.this.text.getText().length();
                        int messageLength = message.length();
                        int end = start + messageLength;
                        TextAppender.this.text.append(message);
                        if (entry.getLevel() == 1) {
                            TextAppender.this.styleErrorEntry(start, messageLength);
                        }
                        end = TextAppender.this.truncate(TextAppender.this.text);
                        TextAppender.this.scrollTo(end);
                    }
                }
            });
        }
    }

    public void widgetDisposed(DisposeEvent e) {
        this.stop();
    }

    private String getMessage(LogEntry entry) {
        Date date = new Date(entry.getTime());
        String dateStr = DateFormat.getInstance().format(date);
        String message = entry.getMessage();
        return String.format("%s: %s\n", dateStr, message);
    }

    private void scrollTo(int position) {
        this.text.setSelection(position, position);
    }

    private void styleErrorEntry(int start, int messageLength) {
        StyleRange range = new StyleRange(this.styleError);
        range.start = start;
        range.length = messageLength;
        this.text.setStyleRange(range);
    }

    private int truncate(StyledText text) {
        int start;
        String content = text.getText();
        int length = content.length();
        if (length > 100000 && (start = content.indexOf(10, 100000)) > -1 && start < length - 1) {
            StyleRange[] ranges;
            StyleRange[] styleRangeArray = ranges = text.getStyleRanges(start, length -= ++start, true);
            int n = ranges.length;
            int n2 = 0;
            while (n2 < n) {
                StyleRange range = styleRangeArray[n2];
                range.start -= start;
                ++n2;
            }
            text.setText(content.substring(start));
            text.setStyleRanges(ranges);
        }
        return length;
    }
}

