/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.customizer.preferences;

import com.silabs.customizer.log.MessageLog;
import com.silabs.customizer.preferences.PreferenceConstants;
import java.io.IOException;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class GeneralPreferences
extends PreferencePage {
    private Button btnShowDefaults;
    private Button btnConfirmOTP;

    public static IPreferenceNode createNode() {
        String id = GeneralPreferences.class.getName();
        GeneralPreferences page = new GeneralPreferences();
        return new PreferenceNode(id, (IPreferencePage)page);
    }

    public GeneralPreferences() {
        super("General");
    }

    public IPreferenceStore getPreferenceStore() {
        return PreferenceConstants.getStore();
    }

    public boolean performOk() {
        IPersistentPreferenceStore store = (IPersistentPreferenceStore)this.getPreferenceStore();
        if (this.btnShowDefaults != null) {
            store.setValue("PREF_SHOW_DEFAULTS", this.btnShowDefaults.getSelection());
            store.setValue("PREF_CONFIRM_OTP", this.btnConfirmOTP.getSelection());
            try {
                store.save();
            }
            catch (IOException ioe) {
                MessageLog.error("Could not save preferences", ioe);
            }
        }
        return super.performOk();
    }

    protected Control createContents(Composite parent) {
        IPreferenceStore store = this.getPreferenceStore();
        Composite result = new Composite(parent, 0);
        result.setLayout((Layout)new RowLayout(512));
        this.btnShowDefaults = new Button(result, 32);
        this.btnShowDefaults.setText("Show 'Defaults' Column");
        this.btnShowDefaults.setSelection(store.getBoolean("PREF_SHOW_DEFAULTS"));
        this.btnConfirmOTP = new Button(result, 32);
        this.btnConfirmOTP.setText("Confirm writes to one-time-programmable devices");
        this.btnConfirmOTP.setSelection(store.getBoolean("PREF_CONFIRM_OTP"));
        return result;
    }

    protected void performDefaults() {
        IPreferenceStore store = this.getPreferenceStore();
        this.btnShowDefaults.setSelection(store.getDefaultBoolean("PREF_SHOW_DEFAULTS"));
        this.btnConfirmOTP.setSelection(store.getDefaultBoolean("PREF_CONFIRM_OTP"));
        super.performDefaults();
    }
}

