/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.customizer.preferences;

import com.silabs.customizer.log.MessageLog;
import com.silabs.customizer.preferences.PreferenceConstants;
import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class SerialNumberPreferences
extends PreferencePage {
    private Button btnRetain;
    private Button btnIncrement;
    private Group grpSerial;
    private Text txtPrefix;
    private Text txtSeed;
    private Spinner spLength;
    private Text txtPostfix;
    private Combo cmbFormat;
    private Label lblNumber;

    public static IPreferenceNode createNode() {
        String id = SerialNumberPreferences.class.getName();
        SerialNumberPreferences page = new SerialNumberPreferences();
        return new PreferenceNode(id, (IPreferencePage)page);
    }

    public SerialNumberPreferences() {
        super("Serial Numbers");
    }

    public IPreferenceStore getPreferenceStore() {
        return PreferenceConstants.getStore();
    }

    public boolean performOk() {
        IPersistentPreferenceStore store = (IPersistentPreferenceStore)this.getPreferenceStore();
        if (this.btnRetain != null) {
            store.setValue("PREF_RETAIN_DEVICE_CONFIG", this.btnRetain.getSelection());
            store.setValue("PREF_SERIAL_AUTOINCREMENT", this.btnIncrement.getSelection());
            store.setValue("PREF_SERIAL_PREFIX", this.txtPrefix.getText().trim());
            store.setValue("PREF_SERIAL_SEED", this.txtSeed.getText().trim());
            int index = Math.max(0, this.cmbFormat.getSelectionIndex());
            store.setValue("PREF_SERIAL_SEED_FORMAT", index);
            store.setValue("PREF_SERIAL_SEED_LENGTH", this.spLength.getSelection());
            store.setValue("PREF_SERIAL_POSTFIX", this.txtPostfix.getText().trim());
            try {
                store.save();
            }
            catch (IOException ioe) {
                MessageLog.error("Could not save preferences", ioe);
            }
        }
        return super.performOk();
    }

    protected Control createContents(Composite parent) {
        IPreferenceStore store = this.getPreferenceStore();
        Composite result = new Composite(parent, 0);
        result.setLayout((Layout)new RowLayout(512));
        int numColumns = 1;
        GridLayoutFactory.swtDefaults().margins(0, 0).numColumns(numColumns).equalWidth(true).applyTo(result);
        this.btnRetain = new Button(result, 32);
        this.btnRetain.setText("Retain device configuration when changing devices");
        this.btnRetain.setSelection(store.getBoolean("PREF_RETAIN_DEVICE_CONFIG"));
        this.btnIncrement = new Button(result, 32);
        this.btnIncrement.setText("Increment serial number after successful program");
        this.btnIncrement.setSelection(store.getBoolean("PREF_SERIAL_AUTOINCREMENT"));
        GridDataFactory gdSerial = GridDataFactory.swtDefaults().indent(17, 0).span(numColumns, 1);
        gdSerial.applyTo((Control)this.btnIncrement);
        this.grpSerial = new Group(result, 0);
        GridLayoutFactory.swtDefaults().numColumns(3).equalWidth(false).applyTo((Composite)this.grpSerial);
        gdSerial.applyTo((Control)this.grpSerial);
        GridDataFactory gdfText = GridDataFactory.swtDefaults().grab(true, false).align(4, 0x1000000);
        Label lblPrefix = new Label((Composite)this.grpSerial, 0);
        lblPrefix.setText("Prefix:");
        String toolTip = "An optional string appearing\nbefore the serial number.";
        lblPrefix.setToolTipText(toolTip);
        this.txtPrefix = new Text((Composite)this.grpSerial, 2052);
        this.txtPrefix.setToolTipText(toolTip);
        this.txtPrefix.setText(store.getString("PREF_SERIAL_PREFIX"));
        gdfText.applyTo((Control)this.txtPrefix);
        new Label((Composite)this.grpSerial, 0);
        Label lblSeed = new Label((Composite)this.grpSerial, 0);
        lblSeed.setText("Serial Seed:");
        toolTip = "The initial value for the serial number.";
        lblSeed.setToolTipText(toolTip);
        this.txtSeed = new Text((Composite)this.grpSerial, 2052);
        this.txtSeed.setToolTipText(toolTip);
        this.txtSeed.setText(store.getString("PREF_SERIAL_SEED"));
        gdfText.applyTo((Control)this.txtSeed);
        this.cmbFormat = new Combo((Composite)this.grpSerial, 12);
        this.cmbFormat.add("Decimal");
        this.cmbFormat.add("Hex");
        int index = Math.max(0, store.getInt("PREF_SERIAL_SEED_FORMAT"));
        if (index >= this.cmbFormat.getItemCount()) {
            index = 0;
        }
        this.cmbFormat.select(index);
        Label lblLength = new Label((Composite)this.grpSerial, 0);
        lblLength.setText("Seed Length:");
        toolTip = "The length of the seed (1-8).";
        lblLength.setToolTipText(toolTip);
        this.spLength = new Spinner((Composite)this.grpSerial, 2304);
        this.spLength.setToolTipText(toolTip);
        this.spLength.setMinimum(1);
        this.spLength.setMaximum(8);
        this.spLength.setIncrement(1);
        this.spLength.setSelection(store.getInt("PREF_SERIAL_SEED_LENGTH"));
        gdfText.applyTo((Control)this.spLength);
        new Label((Composite)this.grpSerial, 0);
        Label lblPostfix = new Label((Composite)this.grpSerial, 0);
        lblPostfix.setText("Postfix:");
        toolTip = "An optional string appearing\nafter the serial number.";
        lblPostfix.setToolTipText(toolTip);
        this.txtPostfix = new Text((Composite)this.grpSerial, 2052);
        this.txtPostfix.setToolTipText(toolTip);
        this.txtPostfix.setText(store.getString("PREF_SERIAL_POSTFIX"));
        gdfText.applyTo((Control)this.txtPostfix);
        new Label((Composite)this.grpSerial, 0);
        Label lblSpacer = new Label((Composite)this.grpSerial, 0);
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)lblSpacer);
        Label lblSerial = new Label((Composite)this.grpSerial, 0);
        lblSerial.setText("Serial Number:");
        this.lblNumber = new Label((Composite)this.grpSerial, 0);
        GC gc = new GC((Drawable)this.lblNumber);
        int charCount = lblSerial.getText().length() + 31;
        int wHint = charCount * gc.getFontMetrics().getAverageCharWidth();
        gc.dispose();
        GridDataFactory.swtDefaults().span(2, 1).hint(wHint, -1).align(4, 0x1000000).applyTo((Control)this.lblNumber);
        this.updateNumber();
        this.addListeners();
        return result;
    }

    protected void performDefaults() {
        IPreferenceStore store = this.getPreferenceStore();
        this.btnRetain.setSelection(store.getDefaultBoolean("PREF_RETAIN_DEVICE_CONFIG"));
        this.btnIncrement.setSelection(store.getDefaultBoolean("PREF_SERIAL_AUTOINCREMENT"));
        this.txtPrefix.setText(store.getDefaultString("PREF_SERIAL_PREFIX"));
        this.txtSeed.setText(store.getDefaultString("PREF_SERIAL_SEED"));
        this.cmbFormat.select(store.getDefaultInt("PREF_SERIAL_SEED_FORMAT"));
        this.spLength.setSelection(store.getDefaultInt("PREF_SERIAL_SEED_LENGTH"));
        this.txtPostfix.setText(store.getDefaultString("PREF_SERIAL_POSTFIX"));
        this.updateNumber();
        this.btnRetainSelection();
        super.performDefaults();
    }

    private void addListeners() {
        this.btnRetain.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SerialNumberPreferences.this.btnRetainSelection();
            }
        });
        this.btnRetainSelection();
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SerialNumberPreferences.this.validate();
                SerialNumberPreferences.this.updateNumber();
            }
        };
        this.txtPrefix.addModifyListener(modifyListener);
        this.txtSeed.addModifyListener(modifyListener);
        this.spLength.addModifyListener(modifyListener);
        this.txtPostfix.addModifyListener(modifyListener);
        this.txtSeed.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                SerialNumberPreferences.this.txtSeed.setText(SerialNumberPreferences.this.txtSeed.getText().trim().toUpperCase(Locale.ENGLISH));
            }
        });
        this.cmbFormat.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SerialNumberPreferences.this.validate();
            }
        });
    }

    private void btnRetainSelection() {
        boolean isEnabled = this.btnRetain.getSelection();
        this.btnIncrement.setEnabled(isEnabled);
        this.grpSerial.setEnabled(isEnabled);
        Control[] controlArray = this.grpSerial.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.setEnabled(isEnabled);
            ++n2;
        }
    }

    private IStatus createErrorStatus(String message) {
        return new Status(4, "com.silabs.customizer", message);
    }

    private String getNumber() {
        String seed = this.txtSeed.getText().trim();
        if (seed.length() < this.spLength.getSelection()) {
            char[] zeroes = new char[this.spLength.getSelection() - seed.length()];
            Arrays.fill(zeroes, '0');
            seed = String.valueOf(String.valueOf(zeroes)) + seed;
        }
        return String.format("%s%s%s", this.txtPrefix.getText().trim(), seed, this.txtPostfix.getText().trim());
    }

    private boolean isDecimal() {
        return this.cmbFormat.getSelectionIndex() == 0;
    }

    private void updateNumber() {
        this.lblNumber.setText(this.getNumber());
    }

    private void validate() {
        IStatus status = Status.OK_STATUS;
        String seed = this.txtSeed.getText().trim();
        if (this.isDecimal()) {
            if (!seed.matches("\\p{Digit}*")) {
                status = this.createErrorStatus("Seed must contain decimal digits (0-9).");
            }
        } else if (!seed.matches("\\p{XDigit}*")) {
            status = this.createErrorStatus("Seed must contain hex digits (0-9, A-F).");
        }
        if (status.isOK() && seed.length() > 8) {
            status = this.createErrorStatus("Seed too long (max. 8 characters).");
        }
        if (status.isOK() && seed.length() == 0) {
            status = this.createErrorStatus("Seed cannot be empty.");
        }
        if (status.isOK() && this.spLength.getSelection() < seed.length()) {
            this.spLength.setSelection(seed.length());
        }
        String message = status.isOK() ? null : status.getMessage();
        this.setErrorMessage(message);
    }
}

