/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.customizer.ui;

import com.silabs.customizer.UIConstants;
import com.silabs.customizer.log.FileAppender;
import com.silabs.customizer.log.MessageLog;
import com.silabs.customizer.log.TextAppender;
import com.silabs.customizer.preferences.PreferenceConstants;
import java.io.File;
import java.io.IOException;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Text;

public class LoggingComposite
extends Composite {
    private final IPersistentPreferenceStore store = PreferenceConstants.getStore();
    private final FileAppender appender = new FileAppender();
    private final Color errorBg;
    private final StyledText txtLog;
    private final Button btnLog;
    private final Text txtFile;
    private final Button btnBrowse;
    private boolean txtFileModified;

    public LoggingComposite(Composite parent, int style) {
        super(parent, style);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                LoggingComposite.this.appender.stop();
            }
        });
        final Font font = new Font((Device)this.getDisplay(), "Consolas", 10, 0);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                font.dispose();
            }
        });
        this.errorBg = new Color((Device)this.getDisplay(), UIConstants.RGB_ERROR_BG);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                LoggingComposite.this.errorBg.dispose();
            }
        });
        int numColumns = 3;
        GridLayoutFactory.swtDefaults().numColumns(numColumns).applyTo((Composite)this);
        this.txtLog = new StyledText((Composite)this, 2634);
        this.txtLog.setFont(font);
        this.txtLog.setBackground(this.getDisplay().getSystemColor(22));
        int heightHint = this.txtLog.getLineHeight() * 7;
        GridDataFactory.swtDefaults().span(numColumns, 1).align(4, 0x1000000).grab(true, false).hint(-1, heightHint).applyTo((Control)this.txtLog);
        new TextAppender(this.txtLog);
        this.btnLog = new Button((Composite)this, 32);
        this.btnLog.setText("&Log Programming to File:");
        this.btnLog.setSelection(this.store.getBoolean("PREF_LOG_TO_FILE"));
        this.txtFile = new Text((Composite)this, 2052);
        this.txtFile.setText(this.store.getString("PREF_LOG_FILE").trim());
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.txtFile);
        this.btnBrowse = new Button((Composite)this, 8);
        this.btnBrowse.setText("...");
        int vIndent = UIConstants.isWsCocoa() ? 2 : 0;
        GridDataFactory.swtDefaults().indent(0, vIndent).applyTo((Control)this.btnBrowse);
        this.addListeners();
    }

    private void addListeners() {
        this.btnLog.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LoggingComposite.this.handleBtnLogSelection();
                LoggingComposite.this.savePrefs();
            }
        });
        this.handleBtnLogSelection();
        this.txtFile.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LoggingComposite.this.validateLogfile();
                LoggingComposite.this.txtFileModified = true;
            }
        });
        this.validateLogfile();
        this.txtFile.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (LoggingComposite.this.txtFileModified) {
                    LoggingComposite.this.useLogFile();
                    LoggingComposite.this.savePrefs();
                    LoggingComposite.this.txtFileModified = false;
                }
            }
        });
        this.useLogFile();
        this.btnBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String result = LoggingComposite.this.openFileDialog();
                if (result != null) {
                    LoggingComposite.this.txtFile.setText(result);
                    LoggingComposite.this.savePrefs();
                }
            }
        });
    }

    private void handleBtnLogSelection() {
        boolean isEnabled = this.btnLog.getSelection();
        this.txtFile.setEnabled(isEnabled);
        this.btnBrowse.setEnabled(isEnabled);
        if (isEnabled) {
            this.appender.start();
        } else {
            this.appender.stop();
        }
    }

    private String openFileDialog() {
        FileDialog dialog = new FileDialog(this.getShell(), 8192);
        dialog.setText("Log Programming to File");
        dialog.setFilterExtensions(new String[]{"*.txt;*.log"});
        String fileName = this.txtFile.getText().trim();
        if (fileName.length() > 0) {
            dialog.setFileName(fileName);
        }
        return dialog.open();
    }

    private void savePrefs() {
        try {
            this.store.setValue("PREF_LOG_TO_FILE", this.btnLog.getSelection());
            this.store.setValue("PREF_LOG_FILE", this.txtFile.getText().trim());
            this.store.save();
        }
        catch (IOException ioe) {
            MessageLog.error("Could not save preferences.", ioe);
        }
    }

    private void useLogFile() {
        String path = this.txtFile.getText().trim();
        if (path.length() > 0) {
            File file = this.appender.isValid(this.txtFile.getText());
            if (file != null) {
                this.txtFile.setText(file.getAbsolutePath());
                this.appender.setFile(file);
                if (this.btnLog.getSelection()) {
                    this.appender.start();
                }
            }
        } else {
            this.appender.stop();
        }
    }

    private void validateLogfile() {
        Color bgColor = null;
        String path = this.txtFile.getText().trim();
        if (path.length() > 0) {
            boolean isValid = this.appender.isValid(path) != null;
            bgColor = isValid ? null : this.errorBg;
        }
        this.txtFile.setBackground(bgColor);
    }
}

