// Copyright (c) 2012

//------------------------------------------------------------------------------
// Global Defines
//------------------------------------------------------------------------------

// The LEDs are on when the pin is at ground.  The values are reversed since
// the initial output state of the PCA is high to keep the LED off.
#define LED_OFF                     0
#define LED_10_PERCENT  (65536*2)*0.1
#define LED_20_PERCENT  (65536*2)*0.2
#define LED_30_PERCENT  (65536*2)*0.3
#define LED_40_PERCENT  (65536*2)*0.4
#define LED_50_PERCENT  (65536*2)*0.5
#define LED_60_PERCENT  (65536*2)*0.6
#define LED_70_PERCENT  (65536*2)*0.7
#define LED_80_PERCENT  (65536*2)*0.8
#define LED_90_PERCENT  (65536*2)*0.9
#define LED_100_PERCENT       65536*2

#define NUM_LED_STEPS              11

#define OFF                         0
#define ON                          1

typedef enum Class_D_LED_Enum
{
    LED0 = 0,
    LED1 = 1,
    LED2 = 2,
    LED3 = 3,
    LED4 = 4,
    LED5 = 5
}
Class_D_LED_Enum_Type;

typedef enum Class_D_LED_Actions_Enum
{
   BRIGHTEN = 0,
   DARKEN = 1,
   DARKEN_THEN_BRIGHTEN_NEXT = 2
}
Class_D_LED_Actions_Enum_Type;

#define Red_LED_On() \
   SI32_PBSTD_A_write_pins_low(SI32_PBSTD_3, 0x0008);

#define Red_LED_Off() \
   SI32_PBSTD_A_write_pins_high(SI32_PBSTD_3, 0x0008);

//------------------------------------------------------------------------------
// Global Variables
//------------------------------------------------------------------------------

extern uint32_t percent_array[NUM_LED_STEPS];
extern Class_D_LED_Actions_Enum_Type LED_direction;
extern int32_t LED_index;
extern Class_D_LED_Enum_Type LED_to_use;
extern bool turn_on_red_led;

//------------------------------------------------------------------------------
// Prototypes
//------------------------------------------------------------------------------

void LED_Manual_Control(Class_D_LED_Enum_Type LED, bool status);
void LED_All_Off(void);
void LED_PCA_Control(Class_D_LED_Enum_Type LED, uint32_t brightness);
void LED_On(Class_D_LED_Enum_Type LED);
void LED_Off(Class_D_LED_Enum_Type LED);
void Switch_LEDs(Class_D_LED_Enum_Type starting_LED);

//------------------------------------------------------------------------------
// End of File
//------------------------------------------------------------------------------
