//-------------------------------------------------------------------------------
// Copyright (c) 2012 by Silicon Laboratories
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Silicon Laboratories End User
// License Agreement which accompanies this distribution, and is available at
// http://developer.silabs.com/legal/version/v10/License_Agreement_v10.htm
//
//
// Original content and implementation provided by Silicon Laboratories
//-------------------------------------------------------------------------------

//==============================================================================
// WARNING:
//
// This file is auto-generated by AppBuilder and should not be modified.
// Any hand modifications will be lost if the project is regenerated.
//==============================================================================

#include "gPLL0.h"
#include "gCPU.h"
#include <stdint.h>
#include <SI32_PLL_A_Type.h>
#include <si32_device.h>

//==============================================================================
// Configuration Functions
//==============================================================================

void PLL0_enter_default_mode()
{
  NVIC_ClearPendingIRQ(PLL0_IRQn);
  NVIC_DisableIRQ(PLL0_IRQn);

  SI32_PLL_A_select_reference_clock_source_usb0osc(SI32_PLL_0);
  SI32_PLL_A_set_numerator(SI32_PLL_0, 4000);
  SI32_PLL_A_set_denominator(SI32_PLL_0, 4000);
  pll_lock_freq_to_hz(48000000, false);
}


//==============================================================================
// Support Functions
//==============================================================================

void pll_lock_freq_to_hz(uint32_t freq, bool phase_lock)
{
  // Calculate initial mode guess
  uint8_t mode = 4;
  if (freq < 35000000)
  {
    mode = 0;
  }
  else if (freq < 45000000)
  {
    mode = 1;
  }
  else if (freq < 55000000)
  {
    mode = 2;
  }
  else if (freq < 70000000)
  {
    mode = 3;
  }

  // Set range
  SI32_PLL_A_select_disable_dco_output(SI32_PLL_0);
  SI32_PLL_A_set_frequency_adjuster_value(SI32_PLL_0, 0xFFF);
  SI32_PLL_A_set_output_frequency_range(SI32_PLL_0, mode);

  // LOCK and block for result
  if (phase_lock)
  {
    SI32_PLL_A_select_dco_phase_lock_mode(SI32_PLL_0);
  }
  else
  {
    SI32_PLL_A_select_dco_frequency_lock_mode(SI32_PLL_0);
  }

  while (!((SI32_PLL_A_is_locked(SI32_PLL_0) == true)
           || (SI32_PLL_A_is_saturation_low_interrupt_pending(SI32_PLL_0) == true)
           || (SI32_PLL_A_is_saturation_high_interrupt_pending(SI32_PLL_0) == true)));

  if (!SI32_PLL_A_is_locked(SI32_PLL_0))
  {
    SI32_PLL_A_select_disable_dco_output(SI32_PLL_0);

    // ADJUST RANGE 
    if (SI32_PLL_A_is_saturation_low_interrupt_pending(SI32_PLL_0) && (mode < 4))
    {
      ++mode;
    }
    else if (mode < 4)
    {
      --mode;
    }
    SI32_PLL_A_set_output_frequency_range(SI32_PLL_0, mode);

    // LOCK and block for result
    if (phase_lock)
    {
      SI32_PLL_A_select_dco_phase_lock_mode(SI32_PLL_0);
    }
    else
    {
      SI32_PLL_A_select_dco_frequency_lock_mode(SI32_PLL_0);
    }

    while (!((SI32_PLL_A_is_locked(SI32_PLL_0) == true)
             || (SI32_PLL_A_is_saturation_low_interrupt_pending(SI32_PLL_0) == true)
             || (SI32_PLL_A_is_saturation_high_interrupt_pending(SI32_PLL_0) == true)));
  }
}
