// Copyright (c) 2012

//------------------------------------------------------------------------------
// Include Files
//------------------------------------------------------------------------------

#include <si32WideTypes.h>

//------------------------------------------------------------------------------
// Definitions
//------------------------------------------------------------------------------

#define MULAW_MAX         0x1FFF
#define MULAW_BIAS            33

//------------------------------------------------------------------------------
// Global Variables
//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
// Functions
//------------------------------------------------------------------------------

// From dystopiancode.blogspot.com
// This implementation was chosen for a small footprint, since table
// implementations may take less time to execute but take up more code space.
//
int8_t muLaw_Encode(int16_t input_data)
{
   uint16_t mask = 0x1000;
   uint8_t sign = 0;
   uint8_t position = 12;
   uint8_t lsb = 0;

   if (input_data < 0)
   {
      input_data = -input_data;
      sign = 0x80;
   }

   input_data += MULAW_BIAS;

   if (input_data > MULAW_MAX)
   {
     input_data = MULAW_MAX;
   }

   for(;((input_data & mask) != mask && position >= 5); mask >>= 1, position--);

   lsb = (input_data >> (position - 4)) & 0x0F;

   return (~(sign | ((position - 5) << 4) | lsb));
}

int16_t muLaw_Decode(int8_t compressed_data)
{
   uint8_t sign = 0;
   uint8_t position = 0;
   int16_t decoded = 0;

   compressed_data = ~compressed_data;

   if (compressed_data & 0x80)
   {
       compressed_data &= ~(1 << 7);
      sign = -1;
   }

   position = ((compressed_data & 0xF0) >> 4) + 5;

   decoded = ((1 << position) | ((compressed_data & 0x0F) << (position - 4))
             | (1 << (position - 5))) - MULAW_BIAS;

   return (sign == 0) ? (decoded) : (-(decoded));
}

//-eof-------------------------------------------------------------------------
