// Copyright (c) 2012

// library
#include <si32McuComponent.h>
// hal
#include <SI32_CLKCTRL_A_Type.h>
#include <SI32_WDTIMER_A_Type.h>
#include <SI32_PBCFG_A_Type.h>
#include <SI32_PBSTD_A_Type.h>
#include <SI32_PBHD_A_Type.h>
#include <SI32_PCACH_A_Type.h>
#include <si32_device.h>
#include <SI32_TIMER_A_Type.h>
#include <SI32_EPCACH_A_Type.h>
#include <SI32_EPCA_A_Type.h>
#include <SI32_FLASHCTRL_A_Type.h>
#include <SI32_PLL_A_Type.h>

// application
#include "myApplication.h"
#include "myCPU.h"
#include "myUSB0.h"
#include "myDataPlane.h"
#include "gModes.h"
#include "class_d.h"
#include "myCAPSENSE0.h"
#include "LED_Control.h"

// This define removes all printf statements, which would cause the board to not
// work without the IDE connected.
#define printf(args...)

//------------------------------------------------------------------------------
// This function is invoked by the CMSIS required SysemInit() function in
// system_<device>.c.  SystemInit() is invoked by Reset_Handler() when the
// CPU boots.  Do not assign any variables here since they will be overwritten
// by __main.
void mySystemInit()
{
  // set interrupt priorities.
  NVIC_SetPriority(SysTick_IRQn, (1 << __NVIC_PRIO_BITS) - 1);

  // disable the watchdog.
  SI32_WDTIMER_A_stop_counter(SI32_WDTIMER_0);
}

//------------------------------------------------------------------------------
void myApplication_initialize()
{
  myCPU_initialize_memory();
  myUSB0_initialize_memory();
}

//------------------------------------------------------------------------------
void myApplication_print_memory_configuration(void)
{
  // Print the memory configuration for imformational purposes.
  printf("retention ram: 0x%08X - 0x%08x, %dKB\n",
         SI32_MCU_RETENTION_RAM_BASE,
         SI32_MCU_RETENTION_RAM_BASE + SI32_MCU_RETENTION_RAM_SIZE - 1,
         SI32_MCU_RETENTION_RAM_SIZE / 1024);
  printf("standard ram: 0x%08X - 0x%08X, %dKB\n",
         SI32_MCU_RAM_BASE,
         SI32_MCU_RAM_BASE + SI32_MCU_RAM_SIZE - 1,
         SI32_MCU_RAM_SIZE / 1024);
}

//------------------------------------------------------------------------------
void myApplication_print_memory_usage(void)
{
  // Print a memory usage summary to the debug printf
  size_t maximum;
  size_t current;
  si32Base_allocation_summary(SI32_HEAP_ZONE, &maximum, &current);
  printf("SI32_HEAP_ZONE cumulative: %d current: %d\n", maximum, current);
  si32Base_allocation_summary(SI32_INCREMENTAL_ZONE, &maximum, &current);
  printf("SI32_INCREMENTAL_ZONE cumulative: %d current: %d\n", maximum, current);
  si32Base_allocation_summary(SI32_RETENTION_ZONE, &maximum, &current);
  printf("SI32_RETENTION_ZONE cumulative: %d current: %d\n", maximum, current);
}

//------------------------------------------------------------------------------
int myApplication_main()
{
   // Enter the default operating mode for this application
   enter_default_mode_from_reset();

   // Disable all the interrupts.  We'll re-enable these later, but we need to
   // finish initializing first.
   NVIC_DisableIRQ(TIMER0H_IRQn);
   NVIC_DisableIRQ(CAPSENSE0_IRQn);
   NVIC_DisableIRQ(TIMER1L_IRQn);

   NVIC_SetPriority(TIMER1L_IRQn, 0);
   NVIC_SetPriority(USB0_IRQn, 1);
   NVIC_SetPriority(TIMER0H_IRQn, 2);
   NVIC_SetPriority(CAPSENSE0_IRQn, 3);

   #if (P32_RELEASE == 1)

   #elif (P32_DEBUG == 1)

   SI32_TIMER_A_enable_stall_in_debug_mode(SI32_TIMER_1);
   SI32_PBSTD_A_set_pins_push_pull_output(SI32_PBSTD_3, 0x0007);

   #elif (UVISION_RELEASE == 1)

   #elif (UVISION_DEBUG == 1)

   SI32_TIMER_A_enable_stall_in_debug_mode(SI32_TIMER_1);
   SI32_PBSTD_A_set_pins_push_pull_output(SI32_PBSTD_3, 0x0007);

   #endif

   // Set the overflow rate for 46.875 kHz
   SI32_TIMER_A_set_low_count(SI32_TIMER_1, 64512);
   SI32_TIMER_A_set_low_reload(SI32_TIMER_1, 64512);

   // Disable the SysTick timer to prevent these interrupts from taking time
   // away from TIMER1, USB, or Class-D.
   SysTick->CTRL &= ~SysTick_CTRL_ENABLE_Msk;

   // Set the initial state of the LED PCA channel so the LED doesn't blip when
   // the PCA starts
   SI32_PCACH_A_set_output_state(SI32_PCA_0_CH0);
   SI32_PBCFG_A_enable_xbar0_signal(SI32_PBCFG_0, SI32_XBAR0_PCA0_CEX0);

   calibrate_capsense();

   erase_Flash();

   // Enable PLL output spectrum spreading
   SI32_PLL_A_set_spectrum_spreading_update_interval(SI32_PLL_0, 0);
   SI32_PLL_A_set_spectrum_spreading_amplitude(SI32_PLL_0,
      SI32_PLL_A_SPECTRUM_SPREADING_AMPLITUDE_1P6_PERCENT);

   // Set EPCA channel initial output state
   SI32_EPCACH_A_set_output_state(SI32_EPCA_0_CH0);
   SI32_EPCACH_A_set_output_state(SI32_EPCA_0_CH1);
   SI32_EPCACH_A_set_output_state(SI32_EPCA_0_CH2);
   SI32_EPCACH_A_set_output_state(SI32_EPCA_0_CH3);

   // Enable the HD I/O after the EPCA PWM is operating
   SI32_PBHD_A_enable_drivers(SI32_PBHD_4);

   // Booted.
   printf("Class-D USB Audio\n");

   // Turn the PLAY_JACK_INPUT mode LED on
   LED_On(LED0);

   NVIC_ClearPendingIRQ(TIMER0H_IRQn);
   NVIC_EnableIRQ(TIMER0H_IRQn);

   NVIC_ClearPendingIRQ(CAPSENSE0_IRQn);
   NVIC_EnableIRQ(CAPSENSE0_IRQn);

   NVIC_ClearPendingIRQ(TIMER1L_IRQn);
   NVIC_EnableIRQ(TIMER1L_IRQn);

   // Enable the USB module, now that everything else is initialized
   myUSB0_enter_active_mode();

   // Start the system running
   SI32_TIMER_A_start_low_timer(SI32_TIMER_1);

   // This enters a while(1) class_d main
   class_d();

   while(1);
}

//---eof------------------------------------------------------------------------

