
//------------------------------------------------------------------------------
// Copyright (c) 2012 by Silicon Laboratories. 
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Silicon Laboratories End User 
// License Agreement which accompanies this distribution, and is available at
// http://developer.silabs.com/legal/version/v10/License_Agreement_v10.htm
// Original content and implementation provided by Silicon Laboratories.
//------------------------------------------------------------------------------

#ifndef __myBuildOptions__guard__
# define __myBuildOptions__guard__

//------------------------------------------------------------------------------
// SI32LIBRARY BUILD OPTIONS - included by si32BaseComponent/si32Base.h
//------------------------------------------------------------------------------
// This file should only be included from si32Base.h, which is included from
// si32BaseComponent.h.  si32Base.h determines the chain at compile time and
// then includes this file.  Refer to si32BaseComponent/si32Base.h for available
// build options.

// Enables si32Assert().
# ifndef si32BuildOption_enable_assertions
#   define si32BuildOption_enable_assertions 1
# endif

// Enables logging.  logging must be enabled to use any si32LogXXX() routine.
# ifndef si32BuildOption_enable_logging
#   define si32BuildOption_enable_logging 0
# endif

// Enable use of computed labels instead of switch abuse for local continuations.
# ifndef si32BuildOption_addressable_labels
#   define si32BuildOption_addressable_labels 1
# endif

// Retention allocation reserve (for MCUs with retention RAM).
# ifndef si32BuildOption_retention_zone_size
#   define si32BuildOption_retention_zone_size 4096
# endif

// Incremental allocation reserve.
# ifndef si32BuildOption_incremental_zone_size
#   define si32BuildOption_incremental_zone_size 4096
# endif

#endif // __myBuildOptions__guard__

//---eof------------------------------------------------------------------------
