// Copyright (c) 2012

#ifndef __MYCAPSENSE0_H__
#define __MYCAPSENSE0_H__

#include <stdbool.h>
#include <si32_device.h>
#include <SI32_CAPSENSE_A_Type.h>

// INCLUDE GENERATED CONTENT
#include "gCAPSENSE0.h"

//==============================================================================
// Function Prototypes
//==============================================================================

// Starts a scan of the slider. This results in multiple convert complete
// flags. When the scan is complete, the touch position is calculated.
void scan_slider(void);

// Perform initial capsense calibration
void calibrate_capsense(void);

//==============================================================================
// Export Public Variables for other Modules
//==============================================================================

// Holds position (virtual) of last detected touch
extern uint8_t CapsenseTouchPos;

// 0 if no touch seen during last poll, else 1
extern bool CapsenseTouch;

extern bool movement;
extern bool touch_lost;
extern uint32_t touch_lost_hysteresis;

#endif //__MYCAPSENSE0_H__
