// Copyright (c) 2012

// hal
// application
#include "myUsbAudioDevice.h"

#ifndef __myDataPlane__guard__
# define __myDataPlane__guard__

// The value of myDataPlaneOutEp is manipulated in myUsbAudiodevice.c in a poller.
// A NULL value for myDataPlaneOutEp indicates that audio-out streaming interface's
// endpoint is not enabled, and therefore no data can flow.  Non NULL indicates
// an enabled endpoint, and data can flow.  This value can change at any time
// and must be periodically checked, as it is currently the data plane thread's
// only information about the state of the USB.  The same is true for myDataPlaneInEp,
// but for the audio-in path.
extern si32UsbEndpointObject* myDataPlaneOutEp;
extern si32UsbEndpointObject* myDataPlaneInEp;

// ----------------------------------------------------------------------------
// Functions and variables for receiving data from the PC
void rx0_callback(obj* delegate,
                         void* context,
                         uint32 tag,
                         obj* buffer,
                         si32IoRequestResultType result,
                         uint32 residue);

void rx1_callback(obj* delegate,
                         void* context,
                         uint32 tag,
                         obj* buffer,
                         si32IoRequestResultType result,
                         uint32 residue);

void rx2_callback(obj* delegate,
                         void* context,
                         uint32 tag,
                         obj* buffer,
                         si32IoRequestResultType result,
                         uint32 residue);

extern uint8 usb_out_buffer[USB_OUT_BUFFER_SIZE*3];

extern bool _receive0;
extern bool _receive1;
extern bool _receive2;

// ----------------------------------------------------------------------------
// Functions and variables for sending data to the PC
void tx0_callback(obj* delegate,
                         void* context,
                         uint32 tag,
                         obj* buffer,
                         si32IoRequestResultType result,
                         uint32 residue);

void tx1_callback(obj* delegate,
                         void* context,
                         uint32 tag,
                         obj* buffer,
                         si32IoRequestResultType result,
                         uint32 residue);

void tx2_callback(obj* delegate,
                         void* context,
                         uint32 tag,
                         obj* buffer,
                         si32IoRequestResultType result,
                         uint32 residue);

extern uint8 usb_in_buffer[USB_IN_BUFFER_SIZE*3];

extern bool _transmit0;
extern bool _transmit1;
extern bool _transmit2;

#endif // __myDataPlane__guard__

//---eof------------------------------------------------------------------------
