// Copyright (c) 2012

// library
#include <si32McuComponent.h>
// hal
// application
#include "myApplication.h"
#include "myDataPlane.h"
#include "myUsbAudioDevice.h"
#include "class_d.h"

si32UsbEndpointObject* myDataPlaneInEp = NULL;

//------------------------------------------------------------------------------

uint8 usb_in_buffer[USB_IN_BUFFER_SIZE*3] = {0};

bool _transmit0 = NO;
bool _transmit1 = NO;
bool _transmit2 = NO;

//------------------------------------------------------------------------------

void tx0_callback(obj* delegate,
                         void* context,
                         uint32 tag,
                         obj* buffer,
                         si32IoRequestResultType result,
                         uint32 residue);

void tx1_callback(obj* delegate,
                         void* context,
                         uint32 tag,
                         obj* buffer,
                         si32IoRequestResultType result,
                         uint32 residue);

void tx2_callback(obj* delegate,
                         void* context,
                         uint32 tag,
                         obj* buffer,
                         si32IoRequestResultType result,
                         uint32 residue);

//------------------------------------------------------------------------------
// This function is called whenever the USB transmit on the first buffer
// (bytes 0-95) completes.  This function will clear the flag, indicating the
// firmware can start writing to that buffer again, and call the next transmit.
//
// By chaining the transmits in this fashion, the system ensures that only
// one transmit operation is in progress at one time.
//
void tx0_callback(obj* delegate,
                         void* context,
                         uint32 tag,
                         obj* buffer,
                         si32IoRequestResultType result,
                         uint32 residue)
{
   si32UsbEndpointObject *ep;

   if (result != SI32_IO_REQUEST_RESULT_CANCELLED)
   {
      sent_in_data_counter = USB_IN_BUFFER_SIZE;

      _transmit0 = NO;

      ep = myDataPlaneInEp;

      if (ep)
      {
         si32IoRequestTagType rqtag = SI32_IO_REQUEST_TAG_ERROR;

         rqtag = si32UsbEndpointObject_transmit(ep,
                                               &usb_in_buffer[USB_IN_BUFFER_SIZE],
                                               USB_IN_BUFFER_SIZE,
                                               tx1_callback,
                                               NULL,
                                               NULL);
         si32Assert(rqtag != SI32_IO_REQUEST_TAG_ERROR);
      }
   }
   else
   {
      usb_recording = 0;
      _transmit0 = NO;
      _transmit1 = NO;
      _transmit2 = NO;
   }
}

//------------------------------------------------------------------------------
// This function is called whenever the USB transmit on the second buffer
// (bytes 96-191) completes.  This function will clear the flag, indicating the
// firmware can start writing to that buffer again, and call the next transmit.
//
// By chaining the transmits in this fashion, the system ensures that only
// one transmit operation is in progress at one time.
//
void tx1_callback(obj* delegate,
                        void* context,
                        uint32 tag,
                        obj* buffer,
                        si32IoRequestResultType result,
                        uint32 residue)
{
   si32UsbEndpointObject *ep;

   if (result != SI32_IO_REQUEST_RESULT_CANCELLED)
   {
      sent_in_data_counter = USB_IN_BUFFER_SIZE*2;

      _transmit1 = NO;

      ep = myDataPlaneInEp;

      if (ep)
      {
         si32IoRequestTagType rqtag = SI32_IO_REQUEST_TAG_ERROR;

         rqtag = si32UsbEndpointObject_transmit(ep,
                                               &usb_in_buffer[USB_IN_BUFFER_SIZE*2],
                                               USB_IN_BUFFER_SIZE,
                                               tx2_callback,
                                               NULL,
                                               NULL);
         si32Assert(rqtag != SI32_IO_REQUEST_TAG_ERROR);
      }
   }
   else
   {
      usb_recording = 0;
      _transmit0 = NO;
      _transmit1 = NO;
      _transmit2 = NO;
   }
}

//------------------------------------------------------------------------------
// This function is called whenever the USB transmit on the third buffer
// (bytes 192-287) completes.  This function will clear the flag, indicating the
// firmware can start writing to that buffer again, and call the next transmit.
//
// By chaining the transmits in this fashion, the system ensures that only
// one transmit operation is in progress at one time.
//
void tx2_callback(obj* delegate,
                        void* context,
                        uint32 tag,
                        obj* buffer,
                        si32IoRequestResultType result,
                        uint32 residue)
{
   si32UsbEndpointObject *ep;

   if (result != SI32_IO_REQUEST_RESULT_CANCELLED)
   {
      // The actual count is 288 here, but in our counter system, that rolls
      // over to 0.
      // This allows the usb_in_data_counter variable to always remain
      // greater than the sent_in_data_counter variable.
      sent_in_data_counter = 0;

      _transmit2 = NO;

      ep = myDataPlaneInEp;

      if (ep)
      {
         si32IoRequestTagType rqtag = SI32_IO_REQUEST_TAG_ERROR;

         rqtag = si32UsbEndpointObject_transmit(ep,
                                               &usb_in_buffer[0],
                                               USB_IN_BUFFER_SIZE,
                                               tx0_callback,
                                               NULL,
                                               NULL);
         si32Assert(rqtag != SI32_IO_REQUEST_TAG_ERROR);
      }
   }
   else
   {
      usb_recording = 0;
      _transmit0 = NO;
      _transmit1 = NO;
      _transmit2 = NO;
   }
}

//---eof------------------------------------------------------------------------
