// Copyright (c) 2012

// library
#include <si32McuComponent.h>
// hal
// application
#include "myApplication.h"
#include "myDataPlane.h"
#include "myUsbAudioDevice.h"
#include "class_d.h"

si32UsbEndpointObject* myDataPlaneOutEp = NULL;

//------------------------------------------------------------------------------

uint8 usb_out_buffer[USB_OUT_BUFFER_SIZE*3] = {0};

bool _receive0 = NO;
bool _receive1 = NO;
bool _receive2 = NO;

//------------------------------------------------------------------------------
// Prototypes
//------------------------------------------------------------------------------

void rx0_callback(obj* delegate,
                         void* context,
                         uint32 tag,
                         obj* buffer,
                         si32IoRequestResultType result,
                         uint32 residue);

void rx1_callback(obj* delegate,
                         void* context,
                         uint32 tag,
                         obj* buffer,
                         si32IoRequestResultType result,
                         uint32 residue);

void rx2_callback(obj* delegate,
                         void* context,
                         uint32 tag,
                         obj* buffer,
                         si32IoRequestResultType result,
                         uint32 residue);

//------------------------------------------------------------------------------
// This function is called whenever the USB receive on the first buffer
// (bytes 0-191) completes.  This function will set the flag, indicating the
// firmware can start reading from that buffer again, and call the next receive.
//
// By chaining the transmits in this fashion, the system ensures that only
// one receive operation is in progress at one time.
//
void rx0_callback(obj* delegate,
                         void* context,
                         uint32 tag,
                         obj* buffer,
                         si32IoRequestResultType result,
                         uint32 residue)
{
   si32UsbEndpointObject *ep;

   if (result != SI32_IO_REQUEST_RESULT_CANCELLED)
   {
      _receive0 = YES;

     ep = myDataPlaneOutEp;

     if (ep)
     {
        si32IoRequestTagType rqtag = SI32_IO_REQUEST_TAG_ERROR;

        rqtag = si32UsbEndpointObject_receive(ep,
                                              &usb_out_buffer[USB_OUT_BUFFER_SIZE],
                                              USB_OUT_BUFFER_SIZE,
                                              rx1_callback,
                                              NULL,
                                              NULL);
        si32Assert(rqtag != SI32_IO_REQUEST_TAG_ERROR);
     }
   }
   else
   {
      _receive0 = NO;
      _receive1 = NO;
      _receive2 = NO;
   }
}

//------------------------------------------------------------------------------
// This function is called whenever the USB receive on the second buffer
// (bytes 192-383) completes.  This function will set the flag, indicating the
// firmware can start reading from that buffer again, and call the next receive.
//
// By chaining the transmits in this fashion, the system ensures that only
// one receive operation is in progress at one time.
//
void rx1_callback(obj* delegate,
                        void* context,
                        uint32 tag,
                        obj* buffer,
                        si32IoRequestResultType result,
                        uint32 residue)
{
   si32UsbEndpointObject *ep;

   if (result != SI32_IO_REQUEST_RESULT_CANCELLED)
   {
      _receive1 = YES;

      ep = myDataPlaneOutEp;

      if (ep)
      {
         si32IoRequestTagType rqtag = SI32_IO_REQUEST_TAG_ERROR;

         rqtag = si32UsbEndpointObject_receive(ep,
                                              &usb_out_buffer[USB_OUT_BUFFER_SIZE*2],
                                              USB_OUT_BUFFER_SIZE,
                                              rx2_callback,
                                              NULL,
                                              NULL);
         si32Assert(rqtag != SI32_IO_REQUEST_TAG_ERROR);
      }
   }
   else
   {
      _receive0 = NO;
      _receive1 = NO;
      _receive2 = NO;
   }
}

//------------------------------------------------------------------------------
// This function is called whenever the USB receive on the first buffer
// (bytes 384-575) completes.  This function will set the flag, indicating the
// firmware can start reading from that buffer again, and call the next receive.
//
// By chaining the transmits in this fashion, the system ensures that only
// one receive operation is in progress at one time.
//
void rx2_callback(obj* delegate,
                        void* context,
                        uint32 tag,
                        obj* buffer,
                        si32IoRequestResultType result,
                        uint32 residue)
{
   si32UsbEndpointObject *ep;

   if (result != SI32_IO_REQUEST_RESULT_CANCELLED)
   {
      _receive2 = YES;

      ep = myDataPlaneOutEp;

      if (ep)
      {
         si32IoRequestTagType rqtag = SI32_IO_REQUEST_TAG_ERROR;

         rqtag = si32UsbEndpointObject_receive(ep,
                                              &usb_out_buffer[0],
                                              USB_OUT_BUFFER_SIZE,
                                              rx0_callback,
                                              NULL,
                                              NULL);
         si32Assert(rqtag != SI32_IO_REQUEST_TAG_ERROR);
      }
   }
   else
   {
      _receive0 = NO;
      _receive1 = NO;
      _receive2 = NO;
   }
}

//---eof------------------------------------------------------------------------
