// Copyright (c) 2012

#include "myTIMER0.h"
#include "myCAPSENSE0.h"
#include "LED_control.h"

#include <SI32_PBSTD_A_Type.h>
#include <SI32_TIMER_A_Type.h>

//==============================================================================
// 2nd Level Interrupt Handlers (Called from generated code)
//==============================================================================
// This ISR handles turning on or off the red LED and initiaiting a CAPSENSE
// slider scan every ~20 ms or so.
//
// This is the lowest priority interrupt, so it will execute after all other
// interrupts are serviced.
void TIMER0H_high_overflow_handler(void)
{
   SI32_TIMER_A_clear_high_overflow_interrupt(SI32_TIMER_0);

   // Handle the red LED here every ~20 ms or so
   if (turn_on_red_led == 1)
   {
      Red_LED_On();

      turn_on_red_led = 0;
   }
   else
   {
      Red_LED_Off();
   }

   scan_slider();
}
