//------------------------------------------------------------------------------
// Copyright (c) 2012 by Silicon Laboratories.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Silicon Laboratories End User
// License Agreement which accompanies this distribution, and is available at
// http://developer.silabs.com/legal/version/v10/License_Agreement_v10.htm
// Original content and implementation provided by Silicon Laboratories.

//------------------------------------------------------------------------------
// Includes
//------------------------------------------------------------------------------

#include "myACCTR0.h"
#include <si32_device.h>
#include <SI32_CLKCTRL_A_Type.h>
#include <SI32_ACCTR_A_Type.h>

//------------------------------------------------------------------------------
// Functions
//------------------------------------------------------------------------------

void ACCTR0_IRQHandler(void)
{
   SI32_ACCTR_A_clear_digital_comparator_0_interrupt_flag(SI32_ACCTR_0);
   SI32_ACCTR_A_write_comp0(SI32_ACCTR_0,
   SI32_ACCTR_A_read_count0(SI32_ACCTR_0) + ACCTR_ALARM_COUNT);
}

void myACCTR0_enter_default_config (void)
{
   // Enable APB clock to LCD module
   SI32_CLKCTRL_A_enable_apb_to_modules_0 (SI32_CLKCTRL_0,
   SI32_CLKCTRL_A_APBCLKG0_ACCTR0CEN_ENABLED_U32);

   // CONFIG register requires a single 32-bit write
   SI32_ACCTR_A_write_config(SI32_ACCTR_0,
   SI32_ACCTR_A_CONFIG_TOPMD_LC_U32|
   SI32_ACCTR_A_CONFIG_PCMD_SINGLE_U32|
   SI32_ACCTR_A_CONFIG_DBGSEL_LCC0_INT0_U32);

   // Poll on write busy flag
   while(SI32_ACCTR_A_is_write_in_progress(SI32_ACCTR_0));

   // Clear CONTROL register for LC mode
   SI32_ACCTR_A_write_control(SI32_ACCTR_0, 0x00000000);
   while(SI32_ACCTR_A_is_write_in_progress(SI32_ACCTR_0));

   // Configure LCCONFIG
   SI32_ACCTR_A_select_extend_low_pulses(SI32_ACCTR_0);
   SI32_ACCTR_A_set_lc_comparator_0_full_range_threshold(SI32_ACCTR_0,35);
   SI32_ACCTR_A_select_comparator_low_side_hysteresis_5_mV(SI32_ACCTR_0);
   SI32_ACCTR_A_select_comparator_high_side_hysteresis_10_mV(SI32_ACCTR_0);
   SI32_ACCTR_A_select_comparator_response_time_400_ns(SI32_ACCTR_0);
   SI32_ACCTR_A_disable_use_lc_comparator_0_for_counter_1(SI32_ACCTR_0);
   SI32_ACCTR_A_disable_force_lc_comparator_0_on(SI32_ACCTR_0);
   SI32_ACCTR_A_disable_force_lc_comparator_1_on(SI32_ACCTR_0);
   while(SI32_ACCTR_A_is_write_in_progress(SI32_ACCTR_0));

   // Configure TIMING register
   SI32_ACCTR_A_disable_lc_bias_pulse_0_offset(SI32_ACCTR_0);
   SI32_ACCTR_A_set_zone_p_time(SI32_ACCTR_0, 1); // must be >0
   SI32_ACCTR_A_set_zone_a_time(SI32_ACCTR_0, 1);

   SI32_ACCTR_A_select_disable_wake_after_zone(SI32_ACCTR_0);
   SI32_ACCTR_A_select_64_cycle_period(SI32_ACCTR_0);
   while(SI32_ACCTR_A_is_write_in_progress(SI32_ACCTR_0));

   // Configure LCMODE register
   SI32_ACCTR_A_disable_lc_automatic_tracking(SI32_ACCTR_0);
   SI32_ACCTR_A_disable_lc_automatic_center_discriminator(SI32_ACCTR_0);
   SI32_ACCTR_A_select_lc_counter_0_input_active_zone_a(SI32_ACCTR_0);
   SI32_ACCTR_A_select_lc_pulse_0_output_active_zone_a(SI32_ACCTR_0);
   SI32_ACCTR_A_select_lc_output_pulse_mode_pulse_low(SI32_ACCTR_0);
   SI32_ACCTR_A_enable_lc_bias_counter_0_zone_p(SI32_ACCTR_0);
   SI32_ACCTR_A_select_lc_bias_counter_0_pulse_high_polarity(SI32_ACCTR_0);
   SI32_ACCTR_A_select_lc_bias_mode_2_internal_only(SI32_ACCTR_0);
   SI32_ACCTR_A_select_lc_mode_4_timed_single_ended(SI32_ACCTR_0);
   SI32_ACCTR_A_select_lc_discriminator_0_hysterisis_minus_3(SI32_ACCTR_0);
   while(SI32_ACCTR_A_is_write_in_progress(SI32_ACCTR_0));

   // Configure LC clock control register
   SI32_ACCTR_A_set_lc_oscillator_reload_value(SI32_ACCTR_0, 1); // min pulse width
   while(SI32_ACCTR_A_is_write_in_progress(SI32_ACCTR_0));

   // Configure LC count register
   SI32_ACCTR_A_set_lc_count_0_discriminator(SI32_ACCTR_0, COUNT_DISCRIMINATOR_0_VALUE);
   SI32_ACCTR_A_set_lc_count_1_discriminator(SI32_ACCTR_0, COUNT_DISCRIMINATOR_1_VALUE);
   while(SI32_ACCTR_A_is_write_in_progress(SI32_ACCTR_0));

   // Configure debounce config CONTROL register
   // Nothing to do

   // Configure DEBUGEN register
   SI32_ACCTR_0->DEBUGEN.U32 = 0x00008708;
   SI32_ACCTR_A_enable_debug_output(SI32_ACCTR_0);
   while(SI32_ACCTR_A_is_write_in_progress(SI32_ACCTR_0));

   // Clear and enable interrupts
   SI32_ACCTR_A_clear_digital_comparator_0_interrupt_flag(SI32_ACCTR_0);
   SI32_ACCTR_A_enable_digital_comparator_0_interrupt(SI32_ACCTR_0);
   NVIC_ClearPendingIRQ(ACCTR0_IRQn);
   NVIC_EnableIRQ(ACCTR0_IRQn);
}

void myACCTR0_start_lc_sequence (void)
{
   // Force LC Sequence to start.
   SI32_ACCTR_A_start_sequencer(SI32_ACCTR_0);
   while(SI32_ACCTR_A_is_write_in_progress(SI32_ACCTR_0));
}

void myACCTR0_enter_sleep_from_default(void)
{
   // CONFIG register requires a single 32-bit write
   SI32_ACCTR_A_write_config(SI32_ACCTR_0,
   SI32_ACCTR_A_CONFIG_TOPMD_LC_U32|
   SI32_ACCTR_A_CONFIG_PCMD_SINGLE_U32);
   SI32_ACCTR_A_disable_debug_output(SI32_ACCTR_0);
   while(SI32_ACCTR_A_is_write_in_progress(SI32_ACCTR_0));
}

void myACCTR0_enter_default_from_sleep(void)
{
   // CONFIG register requires a single 32-bit write
   SI32_ACCTR_A_write_config(SI32_ACCTR_0,
   SI32_ACCTR_A_CONFIG_TOPMD_LC_U32|
   SI32_ACCTR_A_CONFIG_PCMD_SINGLE_U32|
   SI32_ACCTR_A_CONFIG_DBGSEL_LCC0_INT0_U32);
   SI32_ACCTR_A_enable_debug_output(SI32_ACCTR_0);
   while(SI32_ACCTR_A_is_write_in_progress(SI32_ACCTR_0));
}

void myACCTR0_enter_off_config (void)
{
   SI32_ACCTR_A_write_config(SI32_ACCTR_0, 0x00000000);
   while(SI32_ACCTR_A_is_write_in_progress(SI32_ACCTR_0));

   // Disable APB clock to LCD module
   SI32_CLKCTRL_A_disable_apb_to_modules_0 (SI32_CLKCTRL_0,
   SI32_CLKCTRL_A_APBCLKG0_ACCTR0CEN_ENABLED_U32);
}

//=============================================================================
// end of file
//=============================================================================




