//------------------------------------------------------------------------------
// Copyright (c) 2012 by Silicon Laboratories.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Silicon Laboratories End User
// License Agreement which accompanies this distribution, and is available at
// http://developer.silabs.com/legal/version/v10/License_Agreement_v10.htm
// Original content and implementation provided by Silicon Laboratories.
//------------------------------------------------------------------------------
// library
// hal
#include <si32_device.h>
#include <SI32_CLKCTRL_A_Type.h>
#include <SI32_PBSTD_A_Type.h>
#include <SI32_WDTIMER_A_Type.h>
#include <SI32_RSTSRC_A_Type.h>

// application
#include "myCpu.h"

//------------------------------------------------------------------------------
// Function Prototypes
//------------------------------------------------------------------------------

uint32_t get_msTicks(void);

//------------------------------------------------------------------------------
// Functions
//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
// This function is invoked by the CMSIS requires SysemInit() function in
// system_<device>.c.  SystemInit() is invoked by Reset_Handler() when the
// CPU boots.
void mySystemInit()
{
   // disable the watchdog timer to prevent device resets
   // any lines added to this function should be added below this line of code
   SI32_WDTIMER_A_stop_counter (SI32_WDTIMER_0);

   // enable Reset Sources APB clock
   SI32_CLKCTRL_A_enable_apb_to_modules_1(SI32_CLKCTRL_0, SI32_CLKCTRL_A_APBCLKG1_MISC0CEN_ENABLED_U32);

   // Enable system resets to LCD, RTC, and ACCTR
   SI32_RSTSRC_A_enable_system_reset_to_lcd(SI32_RSTSRC_0);
   SI32_RSTSRC_A_enable_system_reset_to_rtc( SI32_RSTSRC_0);
   SI32_RSTSRC_A_enable_system_reset_to_acctr(SI32_RSTSRC_0);

   // enable APB clock to the Port Bank module
   SI32_CLKCTRL_A_enable_apb_to_modules_0 (SI32_CLKCTRL_0, SI32_CLKCTRL_A_APBCLKG0_PB0CEN_MASK);

   // TODO remove this code for rev A1.
   // If not calibrated, then make it so.
   if(*((uint32_t *)0x40029070) != 0x00000017)
      *((uint32_t *)0x40029070) = 0x00000017;
   if(*((uint32_t *)0x40029080) != 0x00000006)
      *((uint32_t *)0x40029080) = 0x00000006;

}

//------------------------------------------------------------------------------
// wait_ms()
//------------------------------------------------------------------------------
void wait_ms(uint32_t delay)
{
   uint32_t alarm;

   alarm = get_msTicks() + delay;

   while (alarm - get_msTicks() > 0);
}

//-eof--------------------------------------------------------------------------
