//------------------------------------------------------------------------------
// Copyright (c) 2012 by Silicon Laboratories.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Silicon Laboratories End User
// License Agreement which accompanies this distribution, and is available at
// http://developer.silabs.com/legal/version/v10/License_Agreement_v10.htm
// Original content and implementation provided by Silicon Laboratories.
//------------------------------------------------------------------------------
// library
#include <stdio.h>
// hal
#include <si32_device.h>
#include <SI32_RTC_B_Type.h>
#include <SI32_PBSTD_A_Type.h>
#include <SI32_CLKCTRL_A_Type.h>
#include <SI32_RSTSRC_A_Type.h>
#include <SI32_PMU_A_Type.h>
#include <SI32_ACCTR_A_Type.h>

// application
#include "myModes.h"
#include "myPB.h"
#include "myRTC0.h"
#include "myLCD0.h"
#include "myACCTR0.h"
#include "myPMU.h"

//-----------------------------------------------------------------------------
// Global Defines
//-----------------------------------------------------------------------------

#define ACCTR_PLUSE_WIDTH 5        // 5 * 1/00Mhz = 500ns bias pulse
#define ACCTR_PULSE_THRESHOLD 25   // low at < 25 pulses
#define ACCTR_ALARM_COUNT 0x10     // alarm every 100 pulses

//-----------------------------------------------------------------------------
// Functions
//-----------------------------------------------------------------------------

void myModes_enter_default_mode(void)
{
   myPMU_enter_default_config();
   myPB_enter_default_config();
   myRTC0_enter_default_config();
   myLCD0_enter_default_config();
   myACCTR0_enter_default_config();

   //FOR LFO
   //myRTC0_enter_lfo_config_from_default();
}

void myModes_enter_active_from_monitor(void)
{
  myPMU_enter_default_from_sleep();
  myPB_enter_default_from_sleep();
  myACCTR0_enter_default_from_sleep();
}

void myModes_enter_active_from_sleep(void)
{
  myPMU_enter_default_from_sleep();
  myPB_enter_default_from_sleep();
  myLCD0_enter_default_config();
  myACCTR0_enter_default_from_sleep();
}

void myModes_enter_monitor_mode(void)
{
  SI32_PMU_A_enable_advanced_capture_counter_wake_event(SI32_PMU_0);
  myACCTR0_enter_sleep_from_default();
  myPB_enter_sleep_from_default();
  myPMU_enter_sleep_from_default();
  myPMU_sleep();
}

void myModes_enter_sleep_mode(void)
{
  SI32_PMU_A_disable_advanced_capture_counter_wake_event(SI32_PMU_0);
  myACCTR0_enter_sleep_from_default();
  myLCD0_enter_off_config();
  myPB_enter_sleep_from_default();
  myPMU_enter_sleep_from_default();
  myPMU_sleep();
}
//==============================================================================

//-eof--------------------------------------------------------------------------
