//------------------------------------------------------------------------------
// Copyright (c) 2012 by Silicon Laboratories.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Silicon Laboratories End User
// License Agreement which accompanies this distribution, and is available at
// http://developer.silabs.com/legal/version/v10/License_Agreement_v10.htm
// Original content and implementation provided by Silicon Laboratories.
//------------------------------------------------------------------------------
// library
// hal
// application
#include "myPb.h"
#include <si32_device.h>
#include <SI32_CLKCTRL_A_Type.h>
#include <SI32_PBCFG_A_Type.h>
#include <SI32_PBGP_A_Type.h>
#include <SI32_PBSTD_A_Type.h>

//-----------------------------------------------------------------------------
// Functions
//-----------------------------------------------------------------------------

void myPB_enter_default_config(void)
{
   SI32_CLKCTRL_A_enable_apb_to_modules_0 (SI32_CLKCTRL_0, SI32_CLKCTRL_A_APBCLKG0_PB0CEN_MASK);

   // PB0.5 through PB0.8 ACCTR analog pins
   SI32_PBSTD_A_set_pins_analog(SI32_PBSTD_0, 0x000001E0);

   // Configure LCD0.0-31 and COM0.0-3 analog
   SI32_PBSTD_A_set_pins_analog(SI32_PBSTD_1, 0x00000F03);
   SI32_PBSTD_A_set_pins_analog(SI32_PBSTD_3, 0x0000FFFF);
   SI32_PBGP_A_set_pins_analog(SI32_PBGP_4, 0x0000FFFF);

   // Configure LC0 Pulse output push-pull
   SI32_PBSTD_A_set_pins_push_pull_output(SI32_PBSTD_0, 0x00000200);
   SI32_PBSTD_A_set_pins_high_drive_strength(SI32_PBSTD_0, 0x00000200);

   // Configure ACCTR DEBUG outputs push-pull
   SI32_PBSTD_A_set_pins_push_pull_output(SI32_PBSTD_1, 0x00000030);

   // ENABLE CROSSBAR(S)
   SI32_PBCFG_A_enable_crossbar_0(SI32_PBCFG_0);
}

void myPB_enter_default_from_sleep(void)
{
   // Configure ACCTR DEBUG outputs push-pull
   SI32_PBSTD_A_set_pins_push_pull_output(SI32_PBSTD_1, 0x00000030);

   // Configure inputs
   SI32_PBSTD_A_set_pins_digital_input(SI32_PBSTD_1, 0x000000C0);
}

void myPB_enter_sleep_from_default(void)
{
   // All pins analog (high-z) accept for ACCTR output pin and wakeup pin
   SI32_PBSTD_A_set_pins_analog(SI32_PBSTD_0, 0x0000FDFD);
   SI32_PBSTD_A_set_pins_analog(SI32_PBSTD_1, 0x0000FF0F);
   SI32_PBSTD_A_set_pins_analog(SI32_PBSTD_2, 0x0000FFFF);
   SI32_PBSTD_A_set_pins_analog(SI32_PBSTD_3, 0x0000FFFF);
}



//-eof--------------------------------------------------------------------------
