//------------------------------------------------------------------------------
// Copyright (c) 2012 by Silicon Laboratories.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Silicon Laboratories End User
// License Agreement which accompanies this distribution, and is available at
// http://developer.silabs.com/legal/version/v10/License_Agreement_v10.htm
// Original content and implementation provided by Silicon Laboratories.
//------------------------------------------------------------------------------

#include <si32_device.h>
#include <SI32_PMU_A_Type.h>
#include <SI32_LDO_A_Type.h>
#include <SI32_RSTSRC_A_Type.h>
#include <SI32_CLKCTRL_A_Type.h>
#include "myPMU.h"

//-----------------------------------------------------------------------------
// Functions
//-----------------------------------------------------------------------------

void PMATCH_IRQHandler(void)
{
   NVIC_DisableIRQ(PMATCH_IRQn);
   NVIC_ClearPendingIRQ(PMATCH_IRQn);
   SI32_PMU_A_clear_wakeup_flags(SI32_PMU_0);
   NVIC_ClearPendingIRQ(PMATCH_IRQn);
}

void myPMU_enter_default_config(void)
{
   // Enable the clock
   SI32_CLKCTRL_A_enable_apb_to_modules_1(SI32_CLKCTRL_0,
                                          SI32_CLKCTRL_A_APBCLKG1_MISC0CEN_ENABLED_U32);

   // Setup the PMU
   SI32_PMU_A_set_ram_retention_enable_mask(SI32_PMU_0, 0xFF);
   SI32_CLKCTRL_A_enable_power_mode_8(SI32_CLKCTRL_0);
   SI32_PMU_A_write_pwpol(SI32_PMU_0, 0x02);
   SI32_PMU_A_write_pwen(SI32_PMU_0, 0x02);
   SI32_PMU_A_clear_wakeup_flags(SI32_PMU_0);
   SI32_PMU_A_enable_pin_wake(SI32_PMU_0);
   SI32_PMU_A_enable_pin_wake_event(SI32_PMU_0);

   // Enable Port Match interrupts for Pin Wake
   NVIC_ClearPendingIRQ(PMATCH_IRQn);
   NVIC_EnableIRQ(PMATCH_IRQn);

   // Disable all resets
   SI32_RSTSRC_0->RESETEN_CLR = 0x0000FFF;
}

void myPMU_enter_sleep_from_default(void)
{
   // Enable charge pump
   SI32_PMU_A_enable_low_power_charge_pump(SI32_PMU_0);

   // Set LDO's to default
   SI32_LDO_A_write_control(SI32_LDO_0, 0x00343434);

   // Finsh chargepump setup
   SI32_PMU_A_enable_low_power_charge_pump_monitor(SI32_PMU_0);
   while(!SI32_PMU_A_is_low_power_charge_pump_voltage_above_threshold(SI32_PMU_0));
   SI32_RSTSRC_A_enable_low_power_mode_charge_pump_reset_source(SI32_RSTSRC_0);
}

void myPMU_enter_default_from_sleep(void)
{
   // Turn off charge pump
   SI32_RSTSRC_A_disable_low_power_mode_charge_pump_reset_source(SI32_RSTSRC_0);
   SI32_PMU_A_disable_low_power_charge_pump_monitor(SI32_PMU_0);
   SI32_PMU_A_disable_low_power_charge_pump(SI32_PMU_0);
}
void myPMU_sleep(void)
{
   SI32_PMU_A_clear_wakeup_flags(SI32_PMU_0);
   SCB->SCR = SCB_SCR_SLEEPDEEP_Msk;      // set SLEEPDEEP

   __DSB();
   __ISB();
   __WFI();
}
