//------------------------------------------------------------------------------
// Copyright (c) 2012 by Silicon Laboratories.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Silicon Laboratories End User
// License Agreement which accompanies this distribution, and is available at
// http://developer.silabs.com/legal/version/v10/License_Agreement_v10.htm
// Original content and implementation provided by Silicon Laboratories.
//------------------------------------------------------------------------------
// library
#include <stdio.h>
// hal
#include <si32_device.h>
#include <SI32_RTC_B_Type.h>
#include <SI32_PBSTD_A_Type.h>
#include <SI32_CLKCTRL_A_Type.h>

// application
#include "myRTC0.h"
#include "myCpu.h"
//#include "myCpu.h"

//------------------------------------------------------------------------------
// Global Defines
//------------------------------------------------------------------------------

#define USE_LPCP

//------------------------------------------------------------------------------
// Functions
//------------------------------------------------------------------------------

void myRTC0_enter_default_config(void)
{
   // Enable RTC APB clock
   SI32_CLKCTRL_A_enable_apb_to_modules_1(SI32_CLKCTRL_0, SI32_CLKCTRL_A_APBCLKG1_MISC0CEN_ENABLED_U32);

   // Start the crystal
   SI32_RTC_B_enable_bias_doubler(SI32_RTC_0);
   SI32_RTC_B_set_rtc_load_capacitance(SI32_RTC_0,7);
   SI32_RTC_B_enable_crystal_oscillator(SI32_RTC_0);

   wait_ms(1);
   while(!SI32_RTC_B_is_external_oscillator_valid(SI32_RTC_0));

   // Switch to RTC
   SI32_RTC_B_set_clock_source_rtc(SI32_RTC_0);

   // Clean up RTC
   SI32_RTC_B_enable_clock_out(SI32_RTC_0);
   SI32_RTC_B_disable_bias_doubler(SI32_RTC_0);
   SI32_RTC_B_enable_auto_gain_control(SI32_RTC_0);

   // Enable output and timer
//   SI32_RTC_B_enable_rtc_timer(SI32_RTC_0);
   SI32_RTC_B_enable_clock_out(SI32_RTC_0);
}

void myRTC0_enter_lfo_config_from_default(void)
{
   // Start the LFO
   SI32_RTC_B_enable_low_frequency_oscillator(SI32_RTC_0);
   SI32_RTC_B_set_clock_source_lfo(SI32_RTC_0);

   // Stop the crystal
   SI32_RTC_B_disable_crystal_oscillator(SI32_RTC_0);
   SI32_RTC_B_disable_bias_doubler(SI32_RTC_0);
   SI32_RTC_B_disable_auto_gain_control(SI32_RTC_0);
}

void myRTC0_enter_default_config_from_lfo(void)
{
   // Start the RTC crystal
   SI32_RTC_B_enable_bias_doubler(SI32_RTC_0);
   SI32_RTC_B_enable_auto_gain_control(SI32_RTC_0);
   SI32_RTC_B_set_rtc_load_capacitance(SI32_RTC_0,7);
   SI32_RTC_B_enable_crystal_oscillator(SI32_RTC_0);

   wait_ms(10);
   while(!SI32_RTC_B_is_external_oscillator_valid(SI32_RTC_0));
   wait_ms(10);

   // Switch to RTC
   SI32_RTC_B_set_clock_source_rtc(SI32_RTC_0);

   // Clean up RTC
   SI32_RTC_B_disable_bias_doubler(SI32_RTC_0);

   // Disable LFO
   SI32_RTC_B_disable_low_frequency_oscillator(SI32_RTC_0);
   SI32_RTC_B_disable_low_frequency_oscillator_output(SI32_RTC_0);

   wait_ms(10);
}

//==============================================================================

//-eof--------------------------------------------------------------------------
