Imports System
Imports System.Collections.Generic
Imports System.Text
Imports System.Runtime.InteropServices

Module SLAB_DFU
    '///////////////////////////////////////////////////////////////////////////
    ' SLAB_DFU.h
    ' For SLAB_DFU.dll version 1.1
    '///////////////////////////////////////////////////////////////////////////

    '///////////////////////////////////////////////////////////////////////////
    ' DLL Preprocessor Definitions
    '///////////////////////////////////////////////////////////////////////////

    '///////////////////////////////////////////////////////////////////////////
    ' Type Definitions - Windows Types
    '///////////////////////////////////////////////////////////////////////////

    '///////////////////////////////////////////////////////////////////////////
    ' Definitions - Windows Definitions
    '///////////////////////////////////////////////////////////////////////////

    Public Const MAX_PATH As Integer = 260

    '///////////////////////////////////////////////////////////////////////////
    ' Type Definitions - DFU_CODE
    '///////////////////////////////////////////////////////////////////////////

    '///////////////////////////////////////////////////////////////////////////
    ' Definitions - Byte : Success Return Codes
    '///////////////////////////////////////////////////////////////////////////

    Public Const DFU_CODE_SUCCESS As Byte = &H00

    '///////////////////////////////////////////////////////////////////////////
    ' Definitions - Byte : API Errors
    '///////////////////////////////////////////////////////////////////////////

    Public Const DFU_CODE_API_INVALID_PARAMETER As Byte = &H40

    Public Const DFU_CODE_API_INVALID_BUFFER_SIZE As Byte = &H41

    Public Const DFU_CODE_API_INVALID_HEX_RECORD As Byte = &H42

    Public Const DFU_CODE_API_NOT_IN_DFU_IDLE_STATE As Byte = &H43

    Public Const DFU_CODE_API_DNLOAD_PHASE_FAILED As Byte = &H44

    Public Const DFU_CODE_API_MANIFEST_PHASE_FAILED As Byte = &H45

    Public Const DFU_CODE_API_INVALID_IMAGE_FILE As Byte = &H46

    Public Const DFU_CODE_API_IMAGE_GENERATION_FAILED As Byte = &H47

    Public Const DFU_CODE_API_INVALID_DEVICE_OBJECT As Byte = &H48

    Public Const DFU_CODE_API_FATAL_ERROR As Byte = &H49

    Public Const DFU_CODE_API_ABORTED As Byte = &H4a

    Public Const DFU_CODE_API_NOT_SUPPORTED As Byte = &H4b

    '///////////////////////////////////////////////////////////////////////////
    ' Definitions - Byte : Hardware Interface Errors
    '///////////////////////////////////////////////////////////////////////////

    Public Const DFU_CODE_HWIF_DEVICE_NOT_FOUND As Byte = &H80

    Public Const DFU_CODE_HWIF_DEVICE_NOT_OPENED As Byte = &H81

    Public Const DFU_CODE_HWIF_DEVICE_ERROR As Byte = &H82

    Public Const DFU_CODE_HWIF_TRANSFER_ERROR As Byte = &H83

    Public Const DFU_CODE_HWIF_TRANSFER_TIMEOUT As Byte = &H84

    Public Const DFU_CODE_HWIF_TRANSFER_INCOMPLETE As Byte = &H85

    '///////////////////////////////////////////////////////////////////////////
    ' Type Definitions - DFU_STATUS
    '///////////////////////////////////////////////////////////////////////////

    '///////////////////////////////////////////////////////////////////////////
    ' Definitions - Byte : Status Values
    '///////////////////////////////////////////////////////////////////////////

    Public Const DFU_STATUS_OK As Byte = &H00

    Public Const DFU_STATUS_ERR_TARGET As Byte = &H01

    Public Const DFU_STATUS_ERR_FILE As Byte = &H02

    Public Const DFU_STATUS_ERR_WRITE As Byte = &H03

    Public Const DFU_STATUS_ERR_ERASE As Byte = &H04

    Public Const DFU_STATUS_ERR_CHECK_ERASED As Byte = &H05

    Public Const DFU_STATUS_ERR_PROG As Byte = &H06

    Public Const DFU_STATUS_ERR_VERIFY As Byte = &H07

    Public Const DFU_STATUS_ERR_ADDRESS As Byte = &H08

    Public Const DFU_STATUS_ERR_NOT_DONE As Byte = &H09

    Public Const DFU_STATUS_ERR_FIRMWARE As Byte = &H0A

    Public Const DFU_STATUS_ERR_VENDOR As Byte = &H0B

    Public Const DFU_STATUS_ERR_USBR As Byte = &H0C

    Public Const DFU_STATUS_ERR_POR As Byte = &H0D

    Public Const DFU_STATUS_ERR_UNKNOWN As Byte = &H0E

    Public Const DFU_STATUS_ERR_STALLED_PKT As Byte = &HF

    Public Const DFU_STATUS_ERR_COMM As Byte = &H10

    '///////////////////////////////////////////////////////////////////////////
    ' Type Definitions - DFU_INTERFACE
    '///////////////////////////////////////////////////////////////////////////

    '///////////////////////////////////////////////////////////////////////////
    ' Definitions - Byte : Interface Types
    '///////////////////////////////////////////////////////////////////////////

    Public Const DFU_INTERFACE_USB As Integer = 0

    Public Const DFU_INTERFACE_UART As Integer = 1

    '///////////////////////////////////////////////////////////////////////////
    ' Type Definitions - DFU_DATA_BITS
    '///////////////////////////////////////////////////////////////////////////

    '///////////////////////////////////////////////////////////////////////////
    ' Definitions - DFU_DATA_BITS
    '///////////////////////////////////////////////////////////////////////////

    Public Const DFU_FIVE_DATA_BITS As Integer = 5
    Public Const DFU_SIX_DATA_BITS As Integer = 6
    Public Const DFU_SEVEN_DATA_BITS As Integer = 7
    Public Const DFU_EIGHT_DATA_BITS As Integer = 8

    '///////////////////////////////////////////////////////////////////////////
    ' Type Definitions - DFU_PARITY
    '///////////////////////////////////////////////////////////////////////////

    '///////////////////////////////////////////////////////////////////////////
    ' Definitions - DFU_PARITY
    '///////////////////////////////////////////////////////////////////////////

    Public Const DFU_NO_PARITY As Integer = 0
    Public Const DFU_ODD_PARITY As Integer = 1
    Public Const DFU_EVEN_PARITY As Integer = 2
    Public Const DFU_MARK_PARITY As Integer = 3
    Public Const DFU_SPACE_PARITY As Integer = 4

    '///////////////////////////////////////////////////////////////////////////
    ' Type Definitions - DFU_STOP_BITS
    '///////////////////////////////////////////////////////////////////////////

    '///////////////////////////////////////////////////////////////////////////
    ' Definitions - DFU_STOP_BITS
    '///////////////////////////////////////////////////////////////////////////

    Public Const DFU_ONE_STOP_BIT As Integer = 0
    Public Const DFU_ONE5_STOP_BITS As Integer = 1
    Public Const DFU_TWO_STOP_BITS As Integer = 2

    '///////////////////////////////////////////////////////////////////////////
    ' Type Definitions - DFU_FLOW_CONTROL
    '///////////////////////////////////////////////////////////////////////////

    '///////////////////////////////////////////////////////////////////////////
    ' Definitions - DFU_FLOW_CONTROL
    '///////////////////////////////////////////////////////////////////////////

    Public Const DFU_NO_FLOW_CONTROL As Integer = 0
    Public Const DFU_RTS_CTS_FLOW_CONTROL As Integer = 1

    '///////////////////////////////////////////////////////////////////////////
    ' Type Definitions - DFU_STATE
    '///////////////////////////////////////////////////////////////////////////

    '///////////////////////////////////////////////////////////////////////////
    ' Definitions - Byte : State Values
    '///////////////////////////////////////////////////////////////////////////

    Public Const DFU_STATE_APP_IDLE As Integer = 0

    Public Const DFU_STATE_APP_DETACH As Integer = 1

    Public Const DFU_STATE_DFU_IDLE As Integer = 2

    Public Const DFU_STATE_DFU_DNLOAD_SYNC As Integer = 3

    Public Const DFU_STATE_DFU_DNBUSY As Integer = 4

    Public Const DFU_STATE_DFU_DNLOAD_IDLE As Integer = 5

    Public Const DFU_STATE_DFU_MANIFEST_SYNC As Integer = 6

    Public Const DFU_STATE_DFU_MANIFEST As Integer = 7

    Public Const DFU_STATE_DFU_MANIFEST_WAIT_RESET As Integer = 8

    Public Const DFU_STATE_DFU_UPLOAD_IDLE As Integer = 9

    Public Const DFU_STATE_DFU_ERROR As Integer = 10

    '///////////////////////////////////////////////////////////////////////////
    ' String Definitions
    '///////////////////////////////////////////////////////////////////////////

    '///////////////////////////////////////////////////////////////////////////
    ' Type Definitions
    '///////////////////////////////////////////////////////////////////////////

    ' USB device

    Public Delegate Function DFU_PROGRESS_CALLBACK(percent As Integer, workInProgress As Boolean, blockID As Integer, userData As IntPtr) As Boolean

    '///////////////////////////////////////////////////////////////////////////
    ' Structures
    '///////////////////////////////////////////////////////////////////////////

    <StructLayout(LayoutKind.Sequential)>
    Public Class DFU_CONTROL_SETUP_PACKET

        Public RequestType As Byte
        Public Request As Byte
        Public Value As UShort
        Public Index As UShort
        Public Length As UShort

    End Class

    <StructLayout(LayoutKind.Sequential)>
    Public Class DFU_GET_STATUS

        Public bStatus As Byte

        Public bwPollTimeout As UInteger

        Public bState As Byte

        Public iString As Byte

    End Class

    <StructLayout(LayoutKind.Sequential)>
    Public Class DFU_GET_INFO

        Public length As UShort

        Public bBootloaderRevision_Major As Byte
        Public bBootloaderRevision_Minor As Byte

        Public bmAttributes As UInteger

        Public wBlockSize As UInteger

        Public maxAppSize As UInteger

        <MarshalAs(UnmanagedType.ByValArray, SizeConst:=16)> Public bDeviceID() As Byte

        <MarshalAs(UnmanagedType.ByValArray, SizeConst:=16)> Public bUUID() As Byte

    End Class

    <StructLayout(LayoutKind.Sequential)>
    Public Class DFU_DEVICE_DESCRIPTOR

        Public bLength As Byte
        Public bDescriptorType As Byte
        Public bcdUSB As UShort
        Public bDeviceClass As Byte
        Public bDeviceSubClass As Byte
        Public bDeviceProtocol As Byte
        Public bMaxPacketSize0 As Byte
        Public idVendor As UShort
        Public idProduct As UShort
        Public bcdDevice As UShort
        Public iManufacturer As Byte
        Public iProduct As Byte
        Public iSerialNumber As Byte
        Public bNumConfigurations As Byte

    End Class

    <StructLayout(LayoutKind.Sequential)>
    Public Class DFU_INTERFACE_DESCRIPTOR

        Public bLength As Byte
        Public bDescriptorType As Byte
        Public bInterfaceNumber As Byte
        Public bAlternateSetting As Byte
        Public bNumEndpoints As Byte
        Public bInterfaceClass As Byte
        Public bInterfaceSubClass As Byte
        Public bInterfaceProtocol As Byte
        Public iInterface As Byte

    End Class

    <StructLayout(LayoutKind.Sequential)>
    Public Class DFU_FUNCTIONAL_DESCRIPTOR

        Public bLength As Byte
        Public bDescriptorType As Byte
        Public bmAttributes As Byte
        Public wDetachTimeOut As UShort
        Public wTransferSize As UShort
        Public bcdDFUVersion As UShort

    End Class

    '///////////////////////////////////////////////////////////////////////////
    ' Exported Library Functions
    '///////////////////////////////////////////////////////////////////////////

    '///////////////////////////////////////////////////////////////////////////
    ' Device Management
    '///////////////////////////////////////////////////////////////////////////

    Public Declare Function DFU_GetGuid Lib "SLAB_DFU.dll" (ByRef guid As Guid) As Byte
    Public Declare Function DFU_SetGuid Lib "SLAB_DFU.dll" (ByRef guid As Guid) As Byte
    Public Declare Function DFU_GetNumDevices Lib "SLAB_DFU.dll" (ByRef numDevices As UInteger) As Byte
    Public Declare Function DFU_GetDevicePath Lib "SLAB_DFU.dll" (deviceIndex As UInteger, path As StringBuilder) As Byte
    Public Declare Function DFU_GetVidPid Lib "SLAB_DFU.dll" (deviceIndex As UInteger, ByRef vid As UShort, ByRef pid As UShort) As Byte
    Public Declare Function DFU_GetInterfaceByIndex Lib "SLAB_DFU.dll" (deviceIndex As UInteger, ByRef type As Byte) As Byte
    Public Declare Function DFU_GetInterfaceByDevicePath Lib "SLAB_DFU.dll" (path As String, ByRef type As Byte) As Byte
    Public Declare Function DFU_GetOpenedDevicePath Lib "SLAB_DFU.dll" (device As IntPtr, path As StringBuilder) As Byte
    Public Declare Function DFU_GetOpenedVidPid Lib "SLAB_DFU.dll" (device As IntPtr, ByRef vid As UShort, ByRef pid As UShort) As Byte
    Public Declare Function DFU_GetOpenedInterface Lib "SLAB_DFU.dll" (device As IntPtr, ByRef type As Byte) As Byte

    Public Declare Function DFU_OpenByIndex Lib "SLAB_DFU.dll" (ByRef device As IntPtr, deviceIndex As UInteger) As Byte
    Public Declare Function DFU_OpenByDevicePath Lib "SLAB_DFU.dll" (ByRef device As IntPtr, path As String) As Byte
    Public Declare Function DFU_Close Lib "SLAB_DFU.dll" (device As IntPtr) As Byte
    Public Declare Function DFU_IsOpened Lib "SLAB_DFU.dll" (device As IntPtr) As Boolean

    '///////////////////////////////////////////////////////////////////////////
    ' Information
    '///////////////////////////////////////////////////////////////////////////

    Public Declare Function DFU_GetLibraryVersion Lib "SLAB_DFU.dll" (ByRef major As Byte, ByRef minor As Byte, ByRef release As Boolean) As Byte

    Public Declare Function DFU_GetDeviceDescriptor Lib "SLAB_DFU.dll" (device As IntPtr, <[In](), Out()> descriptor As DFU_DEVICE_DESCRIPTOR) As Byte
    Public Declare Function DFU_GetInterfaceDescriptor Lib "SLAB_DFU.dll" (device As IntPtr, <[In](), Out()> descriptor As DFU_INTERFACE_DESCRIPTOR) As Byte

    '///////////////////////////////////////////////////////////////////////////
    ' Control Transfers
    '///////////////////////////////////////////////////////////////////////////

    Public Declare Function DFU_ControlTransfer Lib "SLAB_DFU.dll" (device As IntPtr, setup As DFU_CONTROL_SETUP_PACKET, buffer() As Byte, size As UInteger, ByRef bytesTransferred As UInteger) As Byte
    Public Declare Function DFU_SetTransferTimeout Lib "SLAB_DFU.dll" (device As IntPtr, timeout As UInteger) As Byte
    Public Declare Function DFU_GetTransferTimeout Lib "SLAB_DFU.dll" (device As IntPtr, ByRef timeout As UInteger) As Byte

    Public Declare Function DFU_SetUartConfig Lib "SLAB_DFU.dll" (device As IntPtr, baud As UInteger, dataBits As Byte, parity As Byte, stopBits As Byte, flowControl As Byte) As Byte
    Public Declare Function DFU_GetUartConfig Lib "SLAB_DFU.dll" (device As IntPtr, ByRef baud As UInteger, ByRef dataBits As Byte, ByRef parity As Byte, ByRef stopBits As Byte, ByRef flowControl As Byte) As Byte

    '///////////////////////////////////////////////////////////////////////////
    ' DFU Mode
    '///////////////////////////////////////////////////////////////////////////

    Public Declare Function DFU_DfuDnload Lib "SLAB_DFU.dll" (device As IntPtr, buffer() As Byte, size As UShort, block As UShort, ByRef transferred As UShort) As Byte
    Public Declare Function DFU_DfuUpload Lib "SLAB_DFU.dll" (device As IntPtr, buffer() As Byte, size As UShort, block As UShort, ByRef transferred As UShort) As Byte
    Public Declare Function DFU_DfuGetStatus Lib "SLAB_DFU.dll" (device As IntPtr, <[In](), Out()> status As DFU_GET_STATUS) As Byte
    Public Declare Function DFU_DfuClearStatus Lib "SLAB_DFU.dll" (device As IntPtr) As Byte
    Public Declare Function DFU_DfuGetState Lib "SLAB_DFU.dll" (device As IntPtr, ByRef state As Byte) As Byte
    Public Declare Function DFU_DfuAbort Lib "SLAB_DFU.dll" (device As IntPtr) As Byte
    Public Declare Function DFU_SlabGetInfo Lib "SLAB_DFU.dll" (device As IntPtr, <[In](), Out()> info As DFU_GET_INFO) As Byte

    Public Declare Function DFU_DownloadImage Lib "SLAB_DFU.dll" (device As IntPtr, blockSize As UShort, fileName As String, callback As DFU_PROGRESS_CALLBACK, userData As IntPtr, <[In](), Out()> status As DFU_GET_STATUS) As Byte
    Public Declare Function DFU_UploadImage Lib "SLAB_DFU.dll" (device As IntPtr, blockSize As UShort, fileName As String, callback As DFU_PROGRESS_CALLBACK, userData As IntPtr) As Byte
End Module
