;/**************************************************************************//**
; * @brief CMSIS Cortex-M3 Core Device Startup File
; *        for the Silicon Labs EFM32 Gecko Device Series
; ******************************************************************************
; * # License
; * <b>Copyright 2018 Silicon Laboratories Inc. www.silabs.com</b>
; ******************************************************************************
; *
; * The licensor of this software is Silicon Laboratories Inc.  Your use of this
; * software is governed by the terms of Silicon Labs Master Software License
; * Agreement (MSLA) available at
; * www.silabs.com/about-us/legal/master-software-license-agreement.  This
; * software is distributed to you in Source Code format and is governed by the
; * sections of the MSLA applicable to Source Code.
; *
; *****************************************************************************/
        MODULE  ?cstartup

        ;; Forward declaration of sections.
        SECTION CSTACK:DATA:NOROOT(3)
        SECTION .intvec:CODE:NOROOT(2)

        EXTERN  __iar_program_start
        PUBLIC  __vector_table
        PUBLIC  __Vectors, __Vectors_End, __Vectors_Size
        PUBLIC  exit, _exit, __exit

        THUMB
        LDR     R0, =sfe(CSTACK)
        MSR     MSP, R0
        LDR     R0, =__iar_program_start
        BX      R0

        DATA
__vector_table
__Vectors_End
__Vectors       EQU   __vector_table
__Vectors_Size  EQU   __Vectors_End - __Vectors


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; Define exit symbols to avoid the default versions
;;
        THUMB

        SECTION .text:CODE:REORDER:NOROOT(2)
exit:
_exit:
__exit:
        B exit

        END
