/**************************************************************************//**
 * @file main_cmu_example.h
 * @brief CMU Examples for EFM32 Gecko Series 0 and 1
 * @version  1.12

 ******************************************************************************
 * @section License
 * <b>(C) Copyright 2017 Silicon Labs, http://www.silabs.com</b>
 *******************************************************************************
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not
 *    claim that you wrote the original software.
 * 2. Altered source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 3. This notice may not be removed or altered from any source distribution.
 *
 * DISCLAIMER OF WARRANTY/LIMITATION OF REMEDIES: Silicon Labs has no
 * obligation to support this Software. Silicon Labs is providing the
 * Software "AS IS", with no express or implied warranties of any kind,
 * including, but not limited to, any implied warranties of merchantability
 * or fitness for any particular purpose or warranties against infringement
 * of any proprietary rights of a third party.
 *
 * Silicon Labs will not be liable for any consequential, incidental, or
 * special damages, or any other relief, or for any claim by any third party,
 * arising from your use of this Software.
 *
 ******************************************************************************/

#ifndef MAIN_CMU_EXAMPLE_H
#define MAIN_CMU_EXAMPLE_H

#include "em_chip.h"
#include "em_cmu.h"
#include "em_device.h"
#include "em_emu.h"
#include "em_gpio.h"

/* Push buttons and CMU outputs used on different EFM32 STKs */
#if defined(_EFM32_GECKO_FAMILY)
#define USE_SEGMENT_LCD
#define BSP_GPIO_PB0_PORT       gpioPortB
#define BSP_GPIO_PB0_PIN        9
#define BSP_GPIO_PB1_PORT       gpioPortB
#define BSP_GPIO_PB1_PIN        10
#define CMU_OUT0_PORT           gpioPortC       /* CMU_OUT0 for HFRCO */
#define CMU_OUT0_PIN            12
#define CMU_OUT1_PORT           gpioPortD       /* CMU_OUT1 for LFRCO */
#define CMU_OUT1_PIN            8
#define CMU_OUT_PEN_LOC         CMU_ROUTE_CLKOUT0PEN + CMU_ROUTE_CLKOUT1PEN + CMU_ROUTE_LOCATION_LOC1
#define CMU_LFRCO_SELECT        CMU_CTRL_CLKOUTSEL1_LFRCO         
#define CMU_HFRCO_SELECT        CMU_CTRL_CLKOUTSEL0_HFRCO
#define CMU_AUXHFRCO_SELECT     0               /* No AUXHFRCO output on EFM32 Gecko */
#define CMU_CalibrateStop()                     /* No CALSTOP command on EFM32 Gecko */
#elif defined(_EFM32_GIANT_FAMILY) || defined(_EFM32_WONDER_FAMILY) || defined(_EFM32_LEOPARD_FAMILY)
#define USE_SEGMENT_LCD
#define BSP_GPIO_PB0_PORT       gpioPortB
#define BSP_GPIO_PB0_PIN        9
#define BSP_GPIO_PB1_PORT       gpioPortB
#define BSP_GPIO_PB1_PIN        10
#define CMU_OUT1_PORT           gpioPortD       /* CMU_OUT1 for all RC osc */
#define CMU_OUT1_PIN            8
#define CMU_OUT_PEN_LOC         CMU_ROUTE_CLKOUT1PEN + CMU_ROUTE_LOCATION_LOC1
#define CMU_LFRCO_SELECT        CMU_CTRL_CLKOUTSEL1_LFRCOQ         
#define CMU_HFRCO_SELECT        CMU_CTRL_CLKOUTSEL1_HFRCOQ
#define CMU_AUXHFRCO_SELECT     CMU_CTRL_CLKOUTSEL1_AUXHFRCOQ
#elif defined(_EFM32_TINY_FAMILY)
#define USE_SEGMENT_LCD
#define BSP_GPIO_PB0_PORT       gpioPortD
#define BSP_GPIO_PB0_PIN        8
#define BSP_GPIO_PB1_PORT       gpioPortB
#define BSP_GPIO_PB1_PIN        11
#define CMU_OUT0_PORT           gpioPortD       /* CMU_OUT0 for HFRCO & AUXHFRCO */
#define CMU_OUT0_PIN            7
#define CMU_OUT_PEN_LOC         CMU_ROUTE_CLKOUT0PEN + CMU_ROUTE_LOCATION_LOC2
#define CMU_LFRCO_SELECT        0               /* LFRCO not on CMU_OUT0 */  
#define CMU_HFRCO_SELECT        CMU_CTRL_CLKOUTSEL0_HFRCO
#define CMU_AUXHFRCO_SELECT     CMU_CTRL_CLKOUTSEL0_AUXHFRCO
#elif defined(_EFM32_HAPPY_FAMILY)
#include "bspconfig.h"
#define EXIT_BUTTON             "Press PB1 to exit"
#define NEXT_BUTTON             "Press PB1 to next\n"
#define RUN_BUTTON              "\nPress PB0 to start\n"
#define CMU_OUT1_PORT           gpioPortA       /* CMU_OUT1 for all RC osc */
#define CMU_OUT1_PIN            1
#define CMU_OUT_PEN_LOC         CMU_ROUTE_CLKOUT1PEN + CMU_ROUTE_LOCATION_LOC0
#define CMU_LFRCO_SELECT        CMU_CTRL_CLKOUTSEL1_LFRCOQ         
#define CMU_HFRCO_SELECT        CMU_CTRL_CLKOUTSEL1_HFRCOQ
#define CMU_AUXHFRCO_SELECT     CMU_CTRL_CLKOUTSEL1_AUXHFRCOQ
#elif defined(_EFM32_PEARL_FAMILY) || defined(_SILICON_LABS_32B_PLATFORM_2)
#include "bspconfig.h"
#define EXIT_BUTTON             "Press BTN1 to exit"
#define NEXT_BUTTON             "Press BTN1 to next\n"
#define RUN_BUTTON              "\nPress BTN0 to start\n"
#define CMU_OUT1_PORT           gpioPortA       /* CMU_OUT1 for all RC osc */
#define CMU_OUT1_PIN            0
#define CMU_OUT_PEN             CMU_ROUTEPEN_CLKOUT1PEN
#define CMU_OUT_LOC             CMU_ROUTELOC0_CLKOUT1LOC_LOC0
#define CMU_LFRCO_SELECT        CMU_CTRL_CLKOUTSEL1_LFRCOQ         
#define CMU_HFRCO_SELECT        CMU_CTRL_CLKOUTSEL1_HFRCOQ
#define CMU_AUXHFRCO_SELECT     CMU_CTRL_CLKOUTSEL1_AUXHFRCOQ
#else
#error "STK does not support in this application note"
#endif

#if defined(USE_SEGMENT_LCD)
#include "em_lcd.h"
#include "segmentlcd.h"
#else
#include <stdio.h>
#include "em_prs.h"
#include "em_usart.h"
#include "display.h"
#include "textdisplay.h"
#include "retargettextdisplay.h"
#endif

#define CMU_OUT_EN            0
#if CMU_OUT_EN == 1
/* Configure the CMU to output RC oscillator on CMU_OUT0 or CMU_OUT1 pin */
#if !defined(_PRS_CH_CTRL_SOURCESEL_CMU)
#define CMU_OUT_CLR             CMU->CTRL &= ~(_CMU_CTRL_CLKOUTSEL0_MASK + _CMU_CTRL_CLKOUTSEL1_MASK)
#else
/* Keep ULFRCOQ as CLKOUTSEL0 source for PRS to toggle GPIO */
#define CMU_OUT_CLR             CMU->CTRL &= ~(_CMU_CTRL_CLKOUTSEL1_MASK)
#endif
#define CMU_OUT_LFRCO           CMU->CTRL |= CMU_LFRCO_SELECT         
#define CMU_OUT_HFRCO           CMU->CTRL |= CMU_HFRCO_SELECT
#define CMU_OUT_AUXHFRCO        CMU->CTRL |= CMU_AUXHFRCO_SELECT
#if defined( _CMU_STATUS_USHFRCOENS_MASK )
#define CMU_OUT_USHFRCO         CMU->CTRL |= CMU_CTRL_CLKOUTSEL1_USHFRCO
#endif
#else
/* Do nothing if CMU_OUT_EN == 0 */
#define CMU_OUT_CLR            
#define CMU_OUT_LFRCO          
#define CMU_OUT_HFRCO
#define CMU_OUT_AUXHFRCO
#define CMU_OUT_USHFRCO
#endif

/* TOP value for down counter, maximum value is 2^20-1 = 0xFFFFF */
/* Higher value for higher calibration accuracy but longer time */
#define DOWN_TOP_VALUE          0xFFFFF

/* RC oscillator band and frequency for tuning */
#define LFRCO_TUNE_FREQ         32768
#if defined( _CMU_HFRCOCTRL_BAND_MASK )
#define HFRCO_TUNE_BAND         cmuHFRCOBand_14MHz
#define HFRCO_TUNE_FREQ         14000000
#define AUXHFRCO_TUNE_BAND      cmuAUXHFRCOBand_14MHz
#define AUXHFRCO_TUNE_FREQ      14000000
#else
#define HFRCO_TUNE_BAND         cmuHFRCOFreq_19M0Hz
#define HFRCO_TUNE_FREQ         19000000
#define AUXHFRCO_TUNE_BAND      cmuAUXHFRCOFreq_19M0Hz
#define AUXHFRCO_TUNE_FREQ      19000000
#endif

#if defined( _CMU_STATUS_USHFRCOENS_MASK )
#define USHFRCO_TUNE_BAND       cmuUSHFRCOBand_48MHz
#define USHFRCO_TUNE_FREQ       48000000
#define USHFRCO_TUNE_GET        (CMU->USHFRCOCTRL & _CMU_USHFRCOCTRL_TUNING_MASK) >> _CMU_USHFRCOCTRL_TUNING_SHIFT
#define USHFRCO_TUNE_SET        CMU->USHFRCOCTRL = (CMU->USHFRCOCTRL & ~_CMU_USHFRCOCTRL_TUNING_MASK) | (tuningVal << _CMU_USHFRCOCTRL_TUNING_SHIFT)
#endif

/* Menu items */
#define LFRCO_CAL               0
#define HFRCO_CAL               1
#define AUXHFRCO_CAL            2
#define USHFRCO_CAL             3

#if !defined( _CMU_STATUS_USHFRCOENS_MASK )
#define MENU_MAX                3
#else
#define MENU_MAX                4
#endif

/* Functions prototype */
void gpioSetup(void);
void printMenu(void);
bool endOfTune(void);
uint32_t getUpcount(bool targetCnt);
void calibrateRcOsc(CMU_Osc_TypeDef rcOsc, uint32_t rcOscFreq, bool calCont, bool fineEnable);
uint32_t CMU_OscillatorFineTuningGet(CMU_Osc_TypeDef osc);

#endif /* MAIN_CMU_EXAMPLE_H */
