/**************************************************************************//**
 * @file main_cmu_example_s1.h
 * @brief CMU Examples for EFR32/EFM32 Series 1
 * @version  1.13

 ******************************************************************************
 * @section License
 * <b>(C) Copyright 2017 Silicon Labs, http://www.silabs.com</b>
 *******************************************************************************
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not
 *    claim that you wrote the original software.
 * 2. Altered source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 3. This notice may not be removed or altered from any source distribution.
 *
 * DISCLAIMER OF WARRANTY/LIMITATION OF REMEDIES: Silicon Labs has no
 * obligation to support this Software. Silicon Labs is providing the
 * Software "AS IS", with no express or implied warranties of any kind,
 * including, but not limited to, any implied warranties of merchantability
 * or fitness for any particular purpose or warranties against infringement
 * of any proprietary rights of a third party.
 *
 * Silicon Labs will not be liable for any consequential, incidental, or
 * special damages, or any other relief, or for any claim by any third party,
 * arising from your use of this Software.
 *
 ******************************************************************************/

#ifndef MAIN_CMU_EXAMPLE_H
#define MAIN_CMU_EXAMPLE_H

#include "em_device.h"
#include "em_chip.h"
#include "em_cmu.h"
#include "em_emu.h"
#include "em_gpio.h"
#include "em_usart.h"
#include "display.h"
#include "textdisplay.h"
#include "retargettextdisplay.h"

#include <stdio.h>

// BTN1 and BTN0 pins defined in BSP
#include "bspconfig.h"

// Menu messages for push buttons
#define EXIT_BUTTON             "BTN1 to exit\n"
#define NEXT_BUTTON             "BTN1 for next menu\n"
#define START_BUTTON            "BTN0 to start\n"
#define AGAIN_BUTTON            "\nBTN0 to run again\n"

// Enable oscillator output during calibration, if defined
#define CMU_OUT_EN

#if defined(CMU_OUT_EN)

// CLKOUTSELn bit field encodings for each RC oscillator
#define CMU_CTRL_CLKOUTSELN_LFRCOQ      0xA
#define CMU_CTRL_CLKOUTSELN_HFRCOQ      0xC
#define CMU_CTRL_CLKOUTSELN_AUXHFRCOQ   0xD

#if defined(_CMU_STATUS_USHFRCOENS_MASK)
#define CMU_CTRL_CLKOUTSELN_USHFRCOQ    0x12
#endif

#if defined(_EFM32_PEARL_FAMILY)
// Clock output pin on Pearl Gecko STKs
#define CMU_OUT_PORT           gpioPortC       // CMU_OUT1 for all RC osc
#define CMU_OUT_PIN            10
#define CMU_CLKOUTN_MASK        _CMU_CTRL_CLKOUTSEL1_MASK
#define CMU_CLKOUTN_SHIFT       _CMU_CTRL_CLKOUTSEL1_SHIFT
#define CMU_OUT_PEN             CMU_ROUTEPEN_CLKOUT1PEN
#define CMU_OUT_LOC             CMU_ROUTELOC0_CLKOUT1LOC_LOC3
#elif (defined (_EFR32_BLUE_FAMILY) || defined (_EFR32_MIGHTY_FAMILY) || defined (_EFR32_FLEX_FAMILY))
// Clock output pin on Mighty Gecko WSTKs
#define CMU_OUT_PORT           gpioPortC       // CMU_OUT0 for all RC osc
#define CMU_OUT_PIN            11
#define CMU_CLKOUTN_MASK        _CMU_CTRL_CLKOUTSEL0_MASK
#define CMU_CLKOUTN_SHIFT       _CMU_CTRL_CLKOUTSEL0_SHIFT
#define CMU_OUT_PEN             CMU_ROUTEPEN_CLKOUT0PEN
#define CMU_OUT_LOC             CMU_ROUTELOC0_CLKOUT0LOC_LOC3
#elif defined(_EFM32_GIANT_FAMILY) && defined(_SILICON_LABS_32B_SERIES_1)
#define CMU_OUT_PORT           gpioPortE       // CMU_OUT0 for all RC osc
#define CMU_OUT_PIN            12
#define CMU_CLKOUTN_MASK        _CMU_CTRL_CLKOUTSEL1_MASK
#define CMU_CLKOUTN_SHIFT       _CMU_CTRL_CLKOUTSEL1_SHIFT
#define CMU_OUT_PEN             CMU_ROUTEPEN_CLKOUT1PEN
#define CMU_OUT_LOC             CMU_ROUTELOC0_CLKOUT0LOC_LOC2
#else
#error "Device not supported by this code example."
#endif

#endif  /* CMU_OUT_EN */

/*
 * TOP value for the calibration down counter.  Maximum allowed is
 * 2^20-1 = 0xFFFFF.  A larger value for TOP translates into greater
 * accuracy at the expense of a longer calibration period.
 */
#define DOWN_TOP_VALUE          0xFFFFF

// Change the RC oscillator band and tuning frequencies here, if desired
#define LFRCO_TUNE_FREQ         32768
#define HFRCO_TUNE_BAND         cmuHFRCOFreq_19M0Hz
#define HFRCO_TUNE_FREQ         19000000
#define AUXHFRCO_TUNE_BAND      cmuAUXHFRCOFreq_19M0Hz
#define AUXHFRCO_TUNE_FREQ      19000000

// USHFRCO band and tuning frequency, if present
#if defined( _CMU_STATUS_USHFRCOENS_MASK )
#define USHFRCO_TUNE_BAND       cmuUSHFRCOFreq_48M0Hz
#define USHFRCO_TUNE_FREQ       48000000
#define USHFRCO_TUNE_GET        (CMU->USHFRCOCTRL & _CMU_USHFRCOCTRL_TUNING_MASK) >> _CMU_USHFRCOCTRL_TUNING_SHIFT
#define USHFRCO_TUNE_SET        CMU->USHFRCOCTRL = (CMU->USHFRCOCTRL & ~_CMU_USHFRCOCTRL_TUNING_MASK) | (tuningVal << _CMU_USHFRCOCTRL_TUNING_SHIFT)
#endif

// Calibration menu items
#define LFRCO_CAL               0
#define HFRCO_CAL               1
#define AUXHFRCO_CAL            2
#define USHFRCO_CAL             3

#if !defined( _CMU_STATUS_USHFRCOENS_MASK )
#define MENU_MAX                3
#else
#define MENU_MAX                4
#endif

// Functions prototypes
void gpioSetup(void);
void printMenu(void);
bool endOfTune(void);
uint32_t getUpcount(bool targetCnt);
void calibrateRcOsc(CMU_Osc_TypeDef rcOsc, uint32_t rcOscFreq, bool calCont, bool fineEnable);
uint32_t CMU_OscillatorFineTuningGet(CMU_Osc_TypeDef osc);

#endif /* MAIN_CMU_EXAMPLE_H */
